% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SaemixObject.R
\name{createSaemixObject}
\alias{createSaemixObject}
\alias{createSaemixObject.empty}
\alias{createSaemixObject.initial}
\title{Create saemix objects with only data filled in}
\usage{
createSaemixObject.empty(model, data, control = list())
}
\arguments{
\item{model}{an saemixModel object}

\item{data}{an saemixData object}

\item{control}{a list of options (if empty, will be set to the default values by \code{saemixControl})}
}
\value{
an object of class \code{"\linkS4class{SaemixObject}"}.
}
\description{
Create saemix objects either with empty results or with parameters set by the user.
This is an internal function used as a preliminary step to obtain predictions for new data
and is not intended to be used directly.
}
\details{
with createSaemixObject.empty, the data component is set to the data object, the model component is set to the model object, and the result component is empty

with createSaemixObject.initial, the data and model are set as with createSaemixObject.empty,
but the population parameter estimates are used to initialise the result component
as in the initialisation step of the algorithm (initialiseMainAlgo)
}
\examples{
# TODO
}
\keyword{methods}
