% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_plot.R
\name{compare_plot}
\alias{compare_plot}
\alias{compare_plots_saeTrafo}
\alias{compare_plot.NER}
\title{Shows plots for the comparison of estimates}
\usage{
compare_plot(
  model,
  direct,
  MSE = FALSE,
  CV = FALSE,
  label = "orig",
  color = c("blue", "lightblue3"),
  shape = c(16, 16),
  line_type = c("solid", "solid"),
  gg_theme = NULL,
  ...
)

\method{compare_plot}{NER}(
  model = NULL,
  direct = NULL,
  MSE = FALSE,
  CV = FALSE,
  label = "orig",
  color = c("blue", "lightblue3"),
  shape = c(16, 16),
  line_type = c("solid", "solid"),
  gg_theme = NULL,
  ...
)
}
\arguments{
\item{model}{a model object of type "NER", representing point and optional
MSE estimates.}

\item{direct}{an object of type "direct" from "emdi", representing point
and MSE estimates. For more information on how to generate direct estimates,
please see \code{\link[emdi]{direct}}.}

\item{MSE}{optional logical. If \code{TRUE}, the MSE estimates of the direct
and model-based estimates are compared via boxplots and scatter plots.}

\item{CV}{optional logical. If \code{TRUE}, the coefficient of variation
estimates of the direct and model-based estimates are compared via boxplots
and scatter plots.}

\item{label}{argument that enables to customize title and axis labels. There
are three options to label the evaluation plots: (i) original labels
("orig"), (ii) axis labels but no title ("no_title"), (iii) neither axis
labels nor title ("blank").}

\item{color}{a vector with two elements. The first color determines
the color for the regression line in the scatter plot and the color for
the direct estimates in the remaining plots. The second color specifies the
color of the intersection line in the scatter plot and the color for the
model-based estimates in the remaining plots. Defaults to
c("blue", "lightblue3").}

\item{shape}{a numeric vector with two elements. The first shape determines
the shape of the points in the scatterplot and the shape of the points for
the direct estimates in the remaining plots. The second shape determines
the shape for the points for the model-based estimates. The options
are numbered from 0 to 25. Defaults to c(16, 16).}

\item{line_type}{a character vector with two elements. The first line type
determines the line type for the regression line in the scatter plot and the
line type for the direct estimates in the remaining plots. The second line
type specifies the line type of the intersection line in the scatter plot and
the line type for the model-based estimates in the remaining plots. The
options are: "twodash", "solid", "longdash", "dotted", "dotdash", "dashed"
and "blank". Defaults to  c("solid", "solid").}

\item{gg_theme}{\code{\link[ggplot2]{theme}} list from package \pkg{ggplot2}.
For using this argument, package \pkg{ggplot2} must be loaded via
\code{library(ggplot2)}. See also Example 2.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
Plots comparing direct and model-based estimators for the Mean
obtained by \code{\link[ggplot2]{ggplot}}.

A scatter plot and a line plot comparing direct and model-based
estimators for each selected indicator obtained by
\code{\link[ggplot2]{ggplot}}. If the input arguments MSE and CV are set to
\code{TRUE} two extra plots are created, respectively: the MSE/CV estimates
of the direct and model-based estimates are compared by boxplots and scatter
plots.
}
\description{
Function \code{compare_plot} is a generic function used to produce plots
comparing point and existing MSE/CV estimates of direct and model-based
estimation for the Mean.

Methods \code{compare_plot.NER} produce plots comparing point and existing
MSE/CV estimates of direct and model-based estimation from \code{NER_Trafo}.
The direct and model-based point estimates are compared by a scatter plot and
a line plot. If the input arguments MSE and CV are set to TRUE, two extra
plots are created, respectively: the MSE/CV estimates of the direct and
model-based estimates are compared by boxplots and scatter plots.
}
\details{
Since all of the comparisons need a direct estimator, the plots are
only created for in-sample domains.
}
\examples{

\donttest{
# Examples for creating plots to compare the saeTrafo object with direct
# estimates (produced by the package emdi)

# Load Data
data("eusilcA_smp")
data("pop_area_size")
data("pop_mean")
data("pop_cov")

# Nested error regression model
NER_model <- NER_Trafo(fixed = eqIncome ~ gender + eqsize + cash +
                       self_empl + unempl_ben + age_ben + surv_ben +
                       sick_ben + dis_ben + rent + fam_allow + house_allow +
                       cap_inv + tax_adj,
                       smp_domains = "district",
                       pop_area_size = pop_area_size,
                       pop_mean = pop_mean, pop_cov = pop_cov,
                       smp_data = eusilcA_smp, MSE = TRUE)

# Get direct estimates from the R-package emdi
require(emdi)
library(emdi)
emdi_direct <- direct(y = "eqIncome", smp_data = eusilcA_smp,
                      smp_domains = "district", weights = "weight",
                      var = TRUE, na.rm = TRUE)

# Please detach emdi or use saeTrafo::compare_plot

# Example 1: Comparison plots with uncertainty assessment plots
# (for MSE and CV)
saeTrafo::compare_plot(model = NER_model, direct = emdi_direct, MSE = TRUE,
                       CV = TRUE)

# Example 2: Personalize comparison plots using the options provided with
# this function and ggplot themes
require(ggplot2)
library(ggplot2)
saeTrafo::compare_plot(model = NER_model, direct = emdi_direct, MSE = TRUE,
                       CV = TRUE, label = "no_title",
                       color = c("orange", "green"), shape = c(1,2),
                       line_type = c("dotted", "dashed"),
                       gg_theme = theme(
                          text = element_text(size = 20, color = "blue"),
                          panel.border = element_rect(linetype = "dashed",
                                                      fill = "NA")))
}

}
\seealso{
\code{\link{saeTrafoObject}}, \code{\link[emdi]{direct}},
\code{\link{NER_Trafo}}
}
