% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-sample.R
\name{sample_fraction}
\alias{sample_fraction}
\alias{sample_number}
\alias{sample_numbers}
\alias{sample_cluster_number}
\alias{sample_cluster_fraction}
\title{Sampling functions}
\usage{
sample_fraction(size, replace = FALSE, weight = NULL,
  groupVars = NULL)

sample_number(size, replace = FALSE, weight = NULL, groupVars = NULL)

sample_numbers(size, replace = FALSE, groupVars = NULL)

sample_cluster_number(size, replace = FALSE, weight = NULL, groupVars)

sample_cluster_fraction(size, replace = FALSE, weight = NULL,
  groupVars)
}
\arguments{
\item{size}{For \code{sample_n()}, the number of rows to select.
For \code{sample_frac()}, the fraction of rows to select.
If \code{tbl} is grouped, \code{size} applies to each group.}

\item{replace}{Sample with or without replacement?}

\item{weight}{Sampling weights. This must evaluate to a vector of
non-negative numbers the same length as the input. Weights are
automatically standardised to sum to 1.

This argument is automatically \link[rlang:quo]{quoted} and later
\link[rlang:eval_tidy]{evaluated} in the context of the data
frame. It supports \link[rlang:quasiquotation]{unquoting}. See
\code{vignette("programming")} for an introduction to these concepts.}

\item{groupVars}{character with names of variables to be used for grouping.}
}
\description{
These functions are intended to be used with \code{\link{sim_sample}} and not
interactively. They are wrappers around \link[dplyr]{sample_frac} and
\link[dplyr]{sample_n}.
}
\details{
\code{sample_numbers} is a vectorized version of \code{sample_number}.

\code{sample_cluster_number} and \code{sample_cluster_fraction} will sample
  clusters (all units in a cluster).
}
\examples{
sim_base_lm() \%>\% sim_sample(sample_number(5))
sim_base_lm() \%>\% sim_sample(sample_fraction(0.5))
sim_base_lm() \%>\% sim_sample(sample_cluster_number(5, groupVars = "idD"))
sim_base_lm() \%>\% sim_sample(sample_cluster_fraction(0.5, groupVars = "idD"))
}
