% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-generator.R
\name{gen_norm}
\alias{gen_norm}
\alias{gen_v_norm}
\alias{gen_v_sar}
\alias{gen_v_ar1}
\alias{gen_generic}
\title{Generator functions}
\usage{
gen_norm(mean = 0, sd = 1, name = "e")

gen_v_norm(mean = 0, sd = 1, name = "v")

gen_v_sar(mean = 0, sd = 1, rho = 0.5, type = "rook", name)

gen_v_ar1(mean = 0, sd = 1, rho = 0.5, groupVar = "idD",
  timeVar = "idT", name)

gen_generic(generator, ..., groupVars = NULL, name)
}
\arguments{
\item{mean}{the mean passed to the random number generator, for example
\code{\link{rnorm}}.}

\item{sd}{the standard deviation passed to the random number generator, for
example \link{rnorm}.}

\item{name}{name of variable as character in which random numbers are stored.}

\item{rho}{the correlation used to create the variance covariance matrix for
a SAR process - see \code{\link[spdep]{cell2nb}}.}

\item{type}{either "rook" or "queen". See \code{\link[spdep]{cell2nb}} for
details.}

\item{groupVar}{a variable name identifying groups.}

\item{timeVar}{a variable name identifying repeated measurements.}

\item{generator}{a function producing random numbers.}

\item{...}{arguments passed to \code{generator}.}

\item{groupVars}{names of variables as character. Identify groups within
random numbers are constant.}
}
\description{
These functions are intended to be used with \code{\link{sim_gen}} and not
interactively. They are designed to draw random numbers according to the
setting of grouping variables.
}
\details{
\code{gen_norm} is used to draw random numbers from a normal
  distribution where all generated numbers are independent.

\code{gen_v_norm} and \code{gen_v_sar} will create an area-level random
component. In the case of \code{v_norm}, the error component will be from a
normal distribution and i.i.d. from an area-level perspective (all units in
an area will have the same value, all areas are independent). v_sar will also
be from a normal distribution, but the errors are correlated. The variance
covariance matrix is constructed for a SAR(1) - spatial/simultanous
autoregressive process. \link[MASS]{mvrnorm} is used for the random number
generation. \code{gen_v_norm} and \code{gen_v_sar} expect a variable
\code{idD} in the data identifying the areas.

\code{gen_generic} can be used if your world is not normal. You can specify
'any' function as generator, like \code{\link{rnorm}}. Arguments in
\code{...} are matched by name or position. The first argument of
\code{generator} is expected to be the number of random numbers (not
necessarily named \code{n}) and need not to be specified.
}
\examples{
sim_base() \%>\% sim_gen_x() \%>\% sim_gen_e() \%>\% sim_gen_v() \%>\% sim_gen(gen_v_sar(name = "vSP"))

# Generic interface
set.seed(1)
dat1 <- sim(base_id() \%>\%
  sim_gen(gen_generic(rnorm, mean = 0, sd = 4, name = "e")))
set.seed(1)
dat2 <- sim(base_id() \%>\% sim_gen_e())
all.equal(dat1, dat2)
}
\seealso{
\code{\link{sim_gen}}, \code{\link{sim_gen_x}},
  \code{\link{sim_gen_e}}, \code{\link{sim_gen_ec}}, \code{\link{sim_gen_v}},
  \code{\link{sim_gen_vc}}, \code{\link[spdep]{cell2nb}}
}
