\name{summary1way}
\alias{summary1way}
\title{One-way Analysis of Variance Summary}
\usage{
summary1way(fit, digit = 5, conf.level = 0.95, inttype = "tukey",
             pooled = TRUE, print.out = TRUE, draw.plot = TRUE, \dots)
}
\arguments{
 \item{fit}{an lm object, i.e. the output from "lm()".}
 \item{digit}{decimal numbers after the point.}
 \item{conf.level}{confidence level of the intervals.}
 \item{inttype}{three options for intervals appeared on plot:
   "hsd","lsd" or "ci".}
 \item{pooled}{two options: pooled or unpooled standard deviation used
   for plotted intervals.}
 \item{print.out}{if T, print out the output on the screen.}
 \item{draw.plot}{if T, plot data with intervals.}
 \item{\dots}{more options.}
}

\description{
Displays summary information for a one-way anova
analysis. The lm object must come from a numerical response variable
and a single factor. The output includes: (i) anova table; (ii) numeric
summary; (iii) table of effects; (iv) plot of data with intervals.}

\value{
  \item{Df}{degrees of freedom for regression, residual and total.}
  \item{Sum of Sq}{sum squares for regression, residual and total.}
  \item{Mean Sq}{mean squares for regression and residual.}
  \item{F value}{F-statistic value.}
  \item{Pr(F)}
  \item{Main Effect}
  \item{Group Effects}
}

\seealso{
\code{"summary2way", "anova", "aov", "dummy.coef", "plot.oneway"}
}

\examples{
attitudes <- c(5.2,5.2,6.1,6,5.75,5.6,6.25,6.8,6.87,7.1,
               6.3,6.35,5.5,5.75,4.6,5.36,5.85,5.9)
l <- rep(c("Gp1","Gp2","Gp3"),rep(6,3))
l <- factor(l)
f <-lm(attitudes ~ l)
result <- summary1way(f)
result
}

\keyword{models}







