% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2regioncoverer.R
\name{S2Covering}
\alias{S2Covering}
\title{Approximate a Region on the Sphere by a Covering of S2Cells}
\usage{
S2Covering(x, max_cells, min_level, max_level, interior = FALSE)
}
\arguments{
\item{x}{Region to cover. Currently it must be a polygon or cap.}

\item{max_cells}{Positive integer. Maximal number of cells to use in the
covering.}

\item{min_level}{Integer between 0 and 30 specifying the lowest cell level to
use. Must be less than or equal to `max_level`.}

\item{max_level}{Integer between 0 and 30 specifying the highest cell level to
use. Must be greater than or equal to `min_level`.}

\item{interior}{Logical to get an interior covering.}
}
\value{
A list containing an entry `ids` with the ids of the S2Cells used to
cover the region and possibly other entries for internal usage.
}
\description{
Approximate a region on the sphere by a (possibly interior) covering of
S2Cells.
}
