% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{meanProbs}
\alias{meanProbs}
\alias{meanProbs.default}
\title{Calculate expected confidence bands or prediction intreval with normal or t sampling distribution}
\usage{
meanProbs(x, ...)

\method{meanProbs}{default}(
  x,
  probs = seq(0, 1, 0.25),
  na.rm = FALSE,
  names = TRUE,
  useT = TRUE,
  onlyProbs = TRUE,
  pred = FALSE,
  n = 0L,
  ...
)
}
\arguments{
\item{x}{numeric vector whose mean and probability based confidence
values are wanted, NA and NaN values are not allowed in numeric
vectors unless ‘na.rm’ is ‘TRUE’.}

\item{...}{Arguments passed to default method, allows many
different methods to be applied.}

\item{probs}{numeric vector of probabilities with values in the
interval from 0 to 1 .}

\item{na.rm}{logical; if true, any NA and NaN's are removed from
\code{x} before the quantiles are computed.}

\item{names}{logical; if true, the result has a names attribute.}

\item{useT}{logical; if true, use the t-distribution to calculate
the confidence-based estimates. If false use the normal
distribution to calculate the confidence based estimates.}

\item{onlyProbs}{logical; if true, only return the probability
based confidence interval estimates, otherwise return}

\item{pred}{logical; if true use the prediction interval instead of
the confidence interval}

\item{n}{integer/integerish; this is the n used to calculate the
prediction or confidence interval.  When \code{n=0} (default) use the
number of non-\code{NA} observations.}
}
\value{
By default the return has the probabilities as names (if
named) with the points where the expected distribution are
located given the sampling mean and standard deviation. If
\code{onlyProbs=FALSE} then it would prepend mean, variance, standard
deviation, minimum, maximum and number of non-NA observations.
}
\description{
The generic function \code{meanProbs} produces expected confidence bands
under either the t distribution or the normal sampling
distribution. This uses \code{qnorm()} or \code{qt()} with the mean and
standard deviation.
}
\details{
For a single probability, p, it uses either:

mean + qt(p, df=n)*sd/sqrt(n)

or

mean + qnorm(p)*sd/sqrt(n)

The smallest observation corresponds to a probability of 0 and the
largest to a probability of 1 and the mean corresponds to 0.5.

The mean and standard deviation of the sample is calculated based
on Welford's method for a single pass.

This is meant to perform in the same way as \code{quantile()} so it can
be a drop in replacement for code using \code{quantile()} but using
distributional assumptions.
}
\examples{

quantile(x<- rnorm(1001))
meanProbs(x)

# Can get some extra statistics if you request onlyProbs=FALSE
meanProbs(x, onlyProbs=FALSE)

x[2] <- NA_real_

meanProbs(x, onlyProbs=FALSE)

quantile(x<- rnorm(42))

meanProbs(x)

meanProbs(x, useT=FALSE)

}
\author{
Matthew L. Fidler
}
