% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui-rename.R
\name{rxRename}
\alias{rxRename}
\alias{rename.rxUi}
\alias{rename.function}
\title{Rename items inside of a \code{rxode2} ui model}
\usage{
rxRename(.data, ..., envir = parent.frame())

rename.rxUi(.data, ...)

rename.function(.data, ...)
}
\arguments{
\item{.data}{rxode2 ui function, named data to be consistent with \code{dplyr::rename()}}

\item{...}{rename items}

\item{envir}{Environment for evaluation}
}
\value{
New model with items renamed
}
\description{
\code{rxRename()} changes the names of individual variables, lhs, and ode states using
\code{new_name = old_name} syntax
}
\examples{

ocmt <- function() {
   ini({
     tka <- exp(0.45) # Ka
     tcl <- exp(1) # Cl
     ## This works with interactive models
     ## You may also label the preceding line with label("label text")
     tv <- exp(3.45) # log V
     ## the label("Label name") works with all models
     add.sd <- 0.7
   })
   model({
     ka <- tka
     cl <- tcl
     v <- tv
     d/dt(depot) = -ka * depot
     d/dt(center) = ka * depot - cl / v * center
     cp = center / v
     cp ~ add(add.sd)
   })
}

ocmt \%>\% rxRename(cpParent=cp)

}
\author{
Matthew L. Fidler
}
