% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dml_pptx.R
\name{dml_pptx}
\alias{dml_pptx}
\title{DrawingML graphic device for Microsoft PowerPoint}
\usage{
dml_pptx(file = "Rplots.dml", width = 6, height = 6, offx = 1,
  offy = 1, bg = "white", fontname_serif = "Times New Roman",
  fontname_sans = "Calibri", fontname_mono = "Courier New",
  fontname_symbol = "Symbol", pointsize = 12, editable = TRUE, id = 1L,
  next_rels_id = 1L, raster_prefix = "raster_", standalone = TRUE)
}
\arguments{
\item{file}{the file where output will appear.}

\item{height, width}{Height and width in inches.}

\item{offx, offy}{top and left origin of the plot}

\item{bg}{Default background color for the plot (defaults to "white").}

\item{fontname_serif, fontname_sans, fontname_mono, fontname_symbol}{font names for font faces.
Used fonts should be available in the operating system.}

\item{pointsize}{default point size.}

\item{editable}{should vector graphics elements (points, text, etc.) be editable.}

\item{id}{specifies a unique identifier (integer) within the slide
that will contain the DrawingML instructions.}

\item{next_rels_id}{specifies the next unique identifier (integer)
within relationship file that will be used to reference embedded
raster images if any.}

\item{raster_prefix}{string value used as prefix for png
files produced when raster objects are printed on the
graphical device.}

\item{standalone}{produce a standalone drawingml file? If \code{FALSE}, omits
xml header and namespaces.}
}
\description{
Graphics devices for Microsoft PowerPoint DrawingML format.
}
\examples{
dml_pptx( file = tempfile() )
plot(1:11,(-5:5)^2, type='b', main="Simple Example")
dev.off()
}
\seealso{
\code{\link{Devices}}, \code{\link{dml_docx}}, \code{\link{dsvg}}
}
\keyword{device}

