% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvmin_rvmax_rvrange.R
\name{Extremes-rv}
\alias{Extremes-rv}
\alias{min.rv}
\alias{max.rv}
\alias{pmin.rv}
\alias{pmax.rv}
\title{Maxima and Minima of Random Variables}
\arguments{
\item{x}{an \code{rv} or \code{rvsummary} object}

\item{na.rm}{remove missing values?}

\item{\dots}{one or more \code{rv} objects or numeric objects}
}
\value{
A \emph{numeric} vector of the same dimension as \code{x}.
}
\description{
Returns the maxima and minima of the components of a random vector.

\code{rvmin} applies the function \code{min} to each component of the
argument \code{x}.  Missing values are removed.

\code{rvmax} applies the function \code{max} to each component of the
argument \code{x}.  Missing values are removed.

\code{rvrange} applies the function \code{range} to each component of the
argument \code{x}.  Missing values are removed.

\code{min.rv} returns the minimum of the random \emph{vector}, returning
thus one random variable. Similarly \code{max.rv} returns the maximum of a
vector.

\code{pmin.rv} and \code{pmax.rv} returns the componentwise minima or maxima
of several random vectors or constants, yielding thus a random vector of the
same length.
}
\examples{

  x <- rvpois(10, lambda=3)
  rvmin(x)
  rvmax(x)
  rvrange(x)

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\seealso{
\code{\link{rvmedian}}, \code{\link{rvmean}}.
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{classes}
