% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoencoder_robust.R
\name{autoencoder_robust}
\alias{autoencoder_robust}
\title{Create a robust autoencoder}
\usage{
autoencoder_robust(network, sigma = 0.2)
}
\arguments{
\item{network}{Layer construct of class \code{"ruta_network"}}

\item{sigma}{Sigma parameter in the kernel used for correntropy}
}
\value{
A construct of class \code{"ruta_autoencoder"}
}
\description{
A robust autoencoder uses a special objective function,
correntropy, a localized similarity measure which makes it less sensitive
to noise in data. Correntropy specifically measures the probability density
that two events are equal, and is less affected by outliers than the mean
squared error.
}
\references{
\itemize{
\item \href{https://ieeexplore.ieee.org/abstract/document/6854900/}{Robust feature learning by stacked autoencoder with maximum correntropy criterion}
}
}
\seealso{
Other autoencoder variants: \code{\link{autoencoder_contractive}},
  \code{\link{autoencoder_denoising}},
  \code{\link{autoencoder_sparse}},
  \code{\link{autoencoder_variational}},
  \code{\link{autoencoder}}
}
\concept{autoencoder variants}
