% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDividends.R
\name{getDividends}
\alias{getDividends}
\title{Download dividends data}
\usage{
getDividends(
  src = "investing",
  figi = "",
  api.key = "",
  from = Sys.Date() - 10,
  to = Sys.Date(),
  country = ""
)
}
\arguments{
\item{src}{source of dividends information. Could be 'investing' or 'tinkoff'}

\item{figi}{FIGI of the instrument to get dividends for (only for Tinkoff broker)}

\item{api.key}{Tinkoff broker API key (only for Tinkoff broker)}

\item{from}{start date of the dividends data. Default is 10 days ago}

\item{to}{end date of the dividends data. Default is today}

\item{country}{a character string with the country name to filter dividends data for (only for Investing.com)}
}
\value{
a list with dividends data
}
\description{
This function returns dividends data from Investing.com or Tinkoff broker.
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
getDividends(from = Sys.Date(),to = Sys.Date()+10,country = "Australia")
}
\author{
Vyacheslav Arbuzov
}
