% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/meta_smml.R
\name{meta_smml}
\alias{meta_smml}
\title{Downloads and evaluate species presence in SMML DBs}
\usage{
meta_smml(x, spec_type = c("plant", "fungus"), process = TRUE)
}
\arguments{
\item{x}{a vector of class \code{character} containing fungal or plant species or genus names}

\item{spec_type}{a character string specifying the type of \code{x}.
Can be either \code{"plant"} or \code{"fungus"}}

\item{process}{logical, if \code{TRUE} downloading and extraction process is displayed}
}
\value{
an object of class \code{data.frame}: presence/absence
}
\description{
Searches, downloads and evaluates presence/absence of data in the SMML databases
}
\details{
Use this function before deriving data from one of the databases in order to prune your
input species vector. With pruned species vectors the functions will run faster. This is important
if \code{x} is some hundred species long.
}
\examples{
\dontrun{
fungus.meta <- meta_smml(x = "Picea abies", process = TRUE, spec_type = "plant")
fungus.meta
hosts.meta <- meta_smml(x = "Antrodiella citrinella", process = TRUE, spec_type = "fungus")
hosts.meta
}
}
\author{
Franz-Sebastian Krah
}

