% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save-run.R
\name{save_run}
\alias{save_run}
\title{Cache result}
\usage{
save_run(code, file, timing = TRUE)
}
\arguments{
\item{code}{Code to run. Do not forget to wrap it with \code{{ }}. Also, beware
that it is your job to make sure your code and data has not changed. If this
is the case, you need to remove the \code{file} storing the outdated result.}

\item{file}{File path where the result is stored. Should have extension \code{rds}.}

\item{timing}{Whether to print timing of running code? Default is \code{TRUE}.}
}
\value{
The evaluation of \code{code} the first time, the content of \code{file} otherwise.
}
\description{
Cache the result of \code{code} in an RDS file.
}
\examples{
# Prepare some temporary file
tmp <- tempfile(fileext = ".rds")

# Run once because result does not exist yet
save_run({
  Sys.sleep(2)
  1
}, file = tmp)

# Skip run because the result already exists
# (but still output how long it took the first time)
save_run({
  Sys.sleep(2)
  1
}, file = tmp)

}
