% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{which_run}
\alias{which_run}
\title{Running which}
\usage{
which_run(x, k = integer(1), lag = integer(1), which = "last",
  na_rm = TRUE, na_pad = FALSE, idx = integer(0))
}
\arguments{
\item{x}{Vector of any type}

\item{k}{\code{integer} vector or single value denoting size of the running window. If \code{k} is a single
value then window size is constant for all elements, otherwise if \code{length(k) == length(x)} different
window size for each element.}

\item{lag}{\code{integer} vector or single value denoting window lag.
If \code{lag} is a single value then window lag is constant for all elements,
otherwise if \code{length(lag) == length(x)} different window size for each
element. Negative value shifts window forward.}

\item{which}{\code{character} value "first" or "last" denoting if the first or last \code{TRUE}
index is returned from the window.}

\item{na_rm}{\code{logical} single value (default \code{na_rm = TRUE}) -
if \code{TRUE} sum is calculating excluding \code{NA}.}

\item{na_pad}{\code{logical} single value (default \code{na_pad=FALSE}) - if \code{TRUE} calculation on
incomplete window will return \code{NA}. Incomplete window is when some parts of the window are out of range}

\item{idx}{\code{date or integer} an optional integer vector containing index of observation. If specified
then \code{k} and \code{lag} are depending on \code{idx}. Length of \code{idx} should be equal of length \code{x}}
}
\value{
integer vector of indexes of the same length as \code{x}.
}
\description{
\code{min_run} calculates running which - returns index of element where \code{x == TRUE}.
}
\examples{
set.seed(11)
x1 <- sample(c(1, 2, 3), 15, replace = TRUE)
x2 <- sample(c(NA, 1, 2, 3), 15, replace = TRUE)
k  <- sample(1:4, 15, replace = TRUE)
which_run(x1)
which_run(x2, na_rm = TRUE)
which_run(x2, na_rm = TRUE, k = 4)
which_run(x2, na_rm = FALSE, k = k)
}
