# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' List of running windows
#'
#' Creates list of windows
#' @param x Vector of any type
#' @param k integer vector which specifies window length
#' @examples
#' window_run(1:10, k=3)
#' window_run(letters[1:10],k=c(1,2,2,4,5,5,5,5,5,5))
#' @export
window_run <- function(x, k = 0L) {
    .Call('_runner_window_run', PACKAGE = 'runner', x, k)
}

#' List of running windows
#'
#' Creates list of windows
#' @param x Vector of any type
#' @param k integer vector which specifies window length
#' @examples
#' unique_run(1:10, k=3)
#' unique_run(letters[1:10],k=c(1,2,2,4,5,5,5,5,5,5))
#' @export
unique_run <- function(x, k = 0L) {
    .Call('_runner_unique_run', PACKAGE = 'runner', x, k)
}

#' Running minimum
#'
#'
#' \code{min_run} calculates running min on given \code{x} numeric vector, specified \code{k} window size.
#' @param x input numeric vector where running minimum is calculated.
#' @param k Running window size. By default window size equals \code{length(x)}. Allow varying window size specified by vector of \code{length(x)}
#' @param na_pad logical (default \code{na_pad=FALSE}) - if \code{TRUE} first k-results will be filled by \code{NA}. If k is not specified na_pad=F by default.
#' @param na_rm logical (default \code{na_rm=TRUE}) - if \code{TRUE} \code{NA} are replaced by last observed minimum prior to element.
#' @return numeric vector of length equals length of \code{x} containing running min in \code{k}-long window.
#' @examples
#' set.seed(11)
#' x1 <- sample( c(1,2,3), 15, replace=TRUE)
#' x2 <- sample( c(NA,1,2,3), 15, replace=TRUE)
#' k  <- sample( 1:4, 15, replace=TRUE)
#' min_run(x1) # simple cumulative minimum
#' min_run(x2, na_rm = TRUE) # cumulative minimum with removing NA.
#' min_run(x2, na_rm = TRUE, k=4) # minimum in 4-element window
#' min_run(x2, na_rm = FALSE, k=k) # minimum in varying k window size
#' @export
min_run <- function(x, k = 0L, na_rm = TRUE, na_pad = FALSE) {
    .Call('_runner_min_run', PACKAGE = 'runner', x, k, na_rm, na_pad)
}

#' Running maximum
#'
#' \code{max_run} calculates running max on given \code{x} numeric vector and specified \code{k} window size.
#' @param x input numeric vector where running maximum is calculated.
#' @param k Running window size. By default window size equals \code{length(x)}. Allow varying window size specified by vector of \code{length(x)}
#' @param na_pad logical (default \code{na_pad=FALSE}) - if \code{TRUE} first k-results will be filled by \code{NA}. If k is not specified na_pad=F by default.
#' @param na_rm logical (default \code{na_rm=TRUE}) - if \code{TRUE} \code{NA} are replaced by last observed maximum prior to element.
#' @return numeric vector of length equals length of \code{x} containing running max in \code{k}-long window.
#' @examples
#' set.seed(11)
#' x1 <- sample(c(1,2,3), 15, replace=TRUE)
#' x2 <- sample(c(NA,1,2,3), 15, replace=TRUE)
#' k  <- sample(1:4, 15,replace=TRUE)
#' max_run(x1) # simple cumulative minimum
#' max_run(x2, na_rm = TRUE) # cumulative minimum with removing NA.
#' max_run(x2, na_rm = TRUE, k=4) # minimum in 4-element window
#' max_run(x2, na_rm = FALSE, k=k) # minimum in varying k window size
#' @export
max_run <- function(x, k = 0L, na_rm = TRUE, na_pad = FALSE) {
    .Call('_runner_max_run', PACKAGE = 'runner', x, k, na_rm, na_pad)
}

#' Running streak length
#'
#' Calculates running series of consecutive elements
#' @param x vector of any type where running streak is calculated
#' @param k running window size. By default window size equals \code{length(x)}. Allow varying window size specified by vector of \code{length(x)}
#' @param na_rm logical (default \code{na_rm=TRUE}) - if \code{TRUE} \code{NA} are replaced by last observed streak prior to element.
#' @param na_pad logical (default \code{na_pad=FALSE}) - if \code{TRUE} first k-results will be filled by \code{NA}. If k is not specified na_pad=F by default.
#' @return numeric vector of length equals length of \code{x} containing running streak length in \code{k}-long window.
#' @examples
#' set.seed(11)
#' x1 <- sample(c("a","b"),15,replace=TRUE)
#' x2 <- sample(c(NA_character_,"a","b"),15,replace=TRUE)
#' k <- sample(1:4,15,replace=TRUE)
#' streak_run(x1) # simple streak run
#' streak_run(x1, k=2) # streak run within 2-element window
#' streak_run(x2, na_pad=TRUE, k=3) # streak run within k=3 with padding NA
#' streak_run(x1, k=k) # streak run within varying window size specified by vector k
#' @export
streak_run <- function(x, k = 0L, na_rm = TRUE, na_pad = FALSE) {
    .Call('_runner_streak_run', PACKAGE = 'runner', x, k, na_rm, na_pad)
}

#' Fill NA with previous non-NA element
#'
#' Fill \code{NA} with last non-NA element.
#' @param x Vector of any type where \code{NA} are replaced
#' @param run_for_first If first elements are filled with \code{NA}, \code{run_for_first = TRUE } allows to fill all initial \code{NA} with nearest non-NA value. By befault \code{run_for_first = TRUE}
#' @param only_within \code{NA} are replaced only if previous and next non-NA values are the same. By befault \code{only_within = TRUE}
#' @return numeric vector of length equals length of \code{x} containing all \code{x} elements with \code{NA} replaced with previous non-NA element.
#' @examples
#' fill_run(c(NA,NA,1:10, NA, NA), run_for_first=TRUE)
#' fill_run(c(NA,NA,1:10, NA, NA), run_for_first=TRUE)
#' fill_run(c(NA,NA,1:10, NA, NA), run_for_first=FALSE)
#' fill_run(c(NA,NA,1,2,NA,NA,2,2,NA,NA,1, NA, NA), run_for_first=TRUE,only_within = TRUE)
#' @export
fill_run <- function(x, run_for_first = FALSE, only_within = FALSE) {
    .Call('_runner_fill_run', PACKAGE = 'runner', x, run_for_first, only_within)
}

#' Running mean
#'
#'
#' @param x vector of any type on which running mean is calculated
#' @param k running window size. Not yet implemented.
#' @param na_rm logical (default \code{na_rm=TRUE}) - if \code{TRUE} mean is calulating excluding \code{NA}.
#' @param na_pad logical (default \code{na_pad=FALSE}) - if \code{TRUE} first k-results will be filled by \code{NA}. If k is not specified na_pad=F by default.
#' @return numeric vector of length equals length of \code{x} containing running mean in \code{k}-long window.
#' @examples
#' set.seed(11)
#' x1 <- rnorm(15)
#' x2 <- sample(c(rep(NA,5),rnorm(15)), 15, replace=TRUE)
#' k <- sample(1:15, 15, replace=TRUE)
#' mean_run(x1)
#' mean_run(x2, na_rm = TRUE)
#' mean_run(x2, na_rm = FALSE )
#' mean_run(x2, na_rm = TRUE, k=4)
#' @export
mean_run <- function(x, k = 0L, na_rm = TRUE, na_pad = FALSE) {
    .Call('_runner_mean_run', PACKAGE = 'runner', x, k, na_rm, na_pad)
}

#' Running sum
#'
#' Running sum in specified window of numeric vector.
#' @param x vector of any type where running sum is calculated
#' @param k Running window size.  Not yet implemented.
#' @param na_rm logical (default \code{na_rm=TRUE}) - if \code{TRUE} sum is calulating excluding \code{NA}.
#' @param na_pad logical (default \code{na_pad=FALSE}) - if \code{TRUE} first k-results will be filled by \code{NA}. If k is not specified na_pad=F by default.
#' @return numeric vector of length equals length of \code{x} containing running sum in \code{k}-long window.
#' @examples
#' set.seed(11)
#' x1 <- rnorm(15)
#' x2 <- sample(c(rep(NA,5),rnorm(15)), 15, replace=TRUE)
#' k <- sample(1:15, 15, replace=TRUE)
#' sum_run(x1)
#' sum_run(x2, na_rm = TRUE)
#' sum_run(x2, na_rm = FALSE )
#' sum_run(x2, na_rm = TRUE, k=4)
#' @export
sum_run <- function(x, k = 0L, na_rm = TRUE, na_pad = FALSE) {
    .Call('_runner_sum_run', PACKAGE = 'runner', x, k, na_rm, na_pad)
}

#' Running which-true function
#'
#' \code{whicht_run} checks \code{which} element has value TRUE within specified running window.
#' @param x input logical vector where running which-true is calculated.
#' @param k Running window size. By default window size equals \code{length(x)}. Allow varying window size specified by vector of \code{length(x)}
#' @param which specifies whether \code{"first"} or \code{"last"} index is returned.
#' @param na_pad logical (default \code{na_pad=FALSE}) - if \code{TRUE} first k-results will be filled by \code{NA}. If k is not specified na_pad=F by default.
#' @param na_rm logical (default \code{na_rm=TRUE}) - if \code{TRUE} \code{NA} are replaced by last observed minimum prior to element.
#' @return numeric vector of length equals length of \code{x} containing running index in \code{k}-long window.
#' @examples
#' x <- c( NA, FALSE, TRUE, NA, TRUE, FALSE, TRUE, TRUE)
#' whicht_run( x, k=2, na_rm=TRUE, na_pad=FALSE )
#' @export
whicht_run <- function(x, k = 0L, which = "last", na_rm = TRUE, na_pad = FALSE) {
    .Call('_runner_whicht_run', PACKAGE = 'runner', x, k, which, na_rm, na_pad)
}

#' Index of previous, different element
#'
#' Index of previous element different than current
#' @param x vector of any type where running index is calculated
#' @param k running window size. By default window size equals \code{length(x)}. Allow varying window size specified by vector of \code{length(x)}
#' @param na_pad logical (default \code{na_pad=FALSE}) - if \code{TRUE} first k-results will be filled by \code{NA}. If k is not specified na_pad=F by default.
#' @return numeric vector of length equals length of \code{x} containing running index length in \code{k}-long window.
#' @examples
#' set.seed(11)
#' x1 <- sample(c("a","b"),15,replace=TRUE)
#' x2 <- sample(c(NA_character_,"a","b"),15,replace=TRUE)
#' k  <- sample(1:4,15,replace=TRUE)
#' whichd_run(x1)
#' whichd_run(x1, k=2)
#' whichd_run(x2, na_pad=TRUE, k=3)
#' whichd_run(x1, k=k)
#' @export
whichd_run <- function(x, k = 0L, na_pad = FALSE) {
    .Call('_runner_whichd_run', PACKAGE = 'runner', x, k, na_pad)
}

#' Running which.max
#'
#' Running index of the (first or last) maximum.
#' @param x numeric (or integer) vector for which running whichrun is calculated.
#' @param k Running window size. By default window size equals \code{length(x)}. Allow varying window size specified by vector of \code{length(x)}
#' @param which specifies whether \code{"first"} or \code{"last"} index is returned.
#' @param na_pad logical (default \code{na_pad=FALSE}) - if \code{TRUE} first k-results will be filled by \code{NA}. If k is not specified na_pad=F by default.
#' @param na_rm logical (default \code{na_rm=TRUE}) - if \code{TRUE} \code{NA} are replaced by last observed minimum prior to element.
#' @return Numeric vector of length equals length of \code{x} containing running index of maximum in \code{k}-long window.
#' @examples
#' x1 <- c(1, 1, 2, 1, 1, 3, 1, 1, 3, 1, 1, 2, 3, 3, 3)
#' x2 <- c(2, 1, 1, NA, 3, 2, 1, NA, 1, NA, NA, NA, 1, 2, 1)
#' k  <- c(5, 1, 8, 1, 1, 15, 2, 5, 14, 2, 3, 7, 14, 13, 12)
#' whichmax_run(x1, which="first")
#' whichmax_run(x2, na_rm = TRUE, which="last")
#' whichmax_run(x2, k=3, na_rm = TRUE, which="last")
#' whichmax_run(x2 , k=k, na_rm = FALSE, which="first")
#' @export
whichmax_run <- function(x, k = 0L, which = "last", na_rm = TRUE, na_pad = FALSE) {
    .Call('_runner_whichmax_run', PACKAGE = 'runner', x, k, which, na_rm, na_pad)
}

#' Running which.min
#'
#' Running index of the (first or last) maximum.
#' @param x input logical vector where running whichrun is calculated.
#' @param k Running window size. By default window size equals \code{length(x)}. Allow varying window size specified by vector of \code{length(x)}
#' @param which specifies whether \code{"first"} or \code{"last"} index is returned.
#' @param na_pad logical (default \code{na_pad=FALSE}) - if \code{TRUE} first k-results will be filled by \code{NA}. If k is not specified na_pad=F by default.
#' @param na_rm logical (default \code{na_rm=TRUE}) - if \code{TRUE} \code{NA} are replaced by last observed minimum prior to element.
#' @return numeric vector of length equals length of \code{x} containing running index of maximum in \code{k}-long window.
#' @examples
#' set.seed(11)
#' x1 <- c(1, 1, 2, 1, 1, 3, 1, 1, 3, 1, 1, 2, 3, 3, 3)
#' x2 <- c(2, 1, 1, NA, 3, 2, 1, NA, 1, NA, NA, NA, 1, 2, 1)
#' k  <- c(5, 1, 8, 1, 1, 15, 2, 5, 14, 2, 3, 7, 14, 13, 12)
#' whichmin_run( x1 , which="first") # running index of minimum
#' whichmin_run(x1, which="last")
#' whichmin_run( x2, na_rm = TRUE , which="last" ) # running min-index ommiting NA
#' whichmin_run(x2 , k=3, na_rm = TRUE, which="first") # running min-index in 3-element window
#' whichmin_run( x2 , k = k , na_rm = TRUE, which = "last") # running min-index in varying window size
#' @export
whichmin_run <- function(x, k = 0L, which = "last", na_rm = TRUE, na_pad = FALSE) {
    .Call('_runner_whichmin_run', PACKAGE = 'runner', x, k, which, na_rm, na_pad)
}

