% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtsplot.r
\name{rtsplot.polygon}
\alias{rtsplot.polygon}
\title{Add polygon to time series plot}
\usage{
rtsplot.polygon(y, col = graphics::par("col"), ...)
}
\arguments{
\item{y}{\code{\link{xts}} object with 2 columns}

\item{col}{color, \strong{defaults to par('col')}}

\item{...}{additional parameters to the \code{\link{lines}}}
}
\value{
nothing
}
\description{
Add polygon to time series plot
}
\examples{
y = rtsplot.fake.stock.data(1000, ohlc=TRUE) 
symbol = 'SPY'
	
 # moving average
bbands = TTR::BBands(quantmod::HLC(y), n=200, sd=1)[,c('up','dn')]	

 # plot
 layout(1)
 rtsplot(y, type = 'l', col='black')
 col = grDevices::adjustcolor('green', 50/255)
 rtsplot.polygon(bbands, col = col)
rtsplot.legend(c(symbol, 'BBands'), c('black', col), list(y,bbands))

}
