% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim_post.R
\name{results}
\alias{results}
\title{collect observed, modelled, and imputed counts from TRIM output}
\usage{
results(z)
}
\arguments{
\item{z}{TRIM output structure (i.e., output of a call to \code{trim})}
}
\value{
A \code{data.frame}, one row per site-time combination, with columns for
site, year, month (optionally), observed counts, modelled counts and imputed counts.
Missing observations are marked as \code{NA}.
}
\description{
collect observed, modelled, and imputed counts from TRIM output
}
\examples{
data(skylark)
z <- trim(count ~ site + time, data=skylark, model=2);
out <- results(z)
}
\seealso{
Other analyses: \code{\link{coef.trim}},
  \code{\link{confint.trim}}, \code{\link{gof}},
  \code{\link{index}}, \code{\link{now_what}},
  \code{\link{overall}}, \code{\link{overdispersion}},
  \code{\link{plot.trim.index}},
  \code{\link{plot.trim.overall}},
  \code{\link{serial_correlation}},
  \code{\link{summary.trim}}, \code{\link{totals}},
  \code{\link{trim}}, \code{\link{vcov.trim}},
  \code{\link{wald}}
}
