% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/long_to_wide.R
\name{long_to_wide}
\alias{long_to_wide}
\title{Converts a 4-column qPCR long data format to wide format}
\usage{
long_to_wide(x)
}
\arguments{
\item{x}{a 4-column (Condition, gene, Efficiency, Ct) qPCR long data}
}
\value{
A wide qPCR data frame
}
\description{
Converts a 4-column (Condition, gene, Efficiency, Ct) qPCR long data format to wide format
}
\details{
Converts a 4-column (Condition, gene, Efficiency, Ct) qPCR long data format to wide format
}
\examples{

df <- read.table(header = TRUE, text = "
Condition	Gene	E	Ct
control	C2H2-26	1.8	31.26
control	C2H2-26	1.8	31.01
control	C2H2-26	1.8	30.97
treatment	C2H2-26	1.8	32.65
treatment	C2H2-26	1.8	32.03
treatment	C2H2-26	1.8	32.4
control	C2H2-01	1.75	31.06
control	C2H2-01	1.75	30.41
control	C2H2-01	1.75	30.97
treatment	C2H2-01	1.75	28.85
treatment	C2H2-01	1.75	28.93
treatment	C2H2-01	1.75	28.9
control	C2H2-12	2	28.5
control	C2H2-12	2	28.4
control	C2H2-12	2	28.8
treatment	C2H2-12	2	27.9
treatment	C2H2-12	2	28
treatment	C2H2-12	2	27.9
control	ref	1.9	28.87
control	ref	1.9	28.42
control	ref	1.9	28.53
treatment	ref	1.9	28.31
treatment	ref	1.9	29.14
treatment	ref	1.9	28.63")

long_to_wide(df)
}
\author{
Ghader Mirzaghaderi
}
