% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFactor.r
\name{plotFactor}
\alias{plotFactor}
\title{Bar plot of gene expression for 1-, 2-, or 3-factor experiments}
\usage{
plotFactor(
  data,
  x_col,
  y_col,
  Lower.se_col,
  Upper.se_col,
  group_col = NULL,
  facet_col = NULL,
  letters_col = NULL,
  letters_d = 0.2,
  col_width = 0.8,
  err_width = 0.15,
  dodge_width = 0.8,
  fill_colors = NULL,
  alpha = 1,
  base_size = 12,
  legend_position = "right",
  ...
)
}
\arguments{
\item{data}{Data frame containing expression results}

\item{x_col}{Character. Column name for x-axis}

\item{y_col}{Character. Column name for bar height}

\item{Lower.se_col}{Character. Column name for lower SE}

\item{Upper.se_col}{Character. Column name for upper SE}

\item{group_col}{Character. Column name for grouping bars (optional)}

\item{facet_col}{Character. Column name for faceting (optional)}

\item{letters_col}{Character. Column name for significance letters (optional)}

\item{letters_d}{Numeric. Vertical offset for letters (default \code{0.2})}

\item{col_width}{Numeric. Width of bars (default \code{0.8})}

\item{err_width}{Numeric. Width of error bars (default \code{0.15})}

\item{dodge_width}{Numeric. Width of dodge for grouped bars (default \code{0.8})}

\item{fill_colors}{Optional vector of fill colors}

\item{alpha}{Numeric. Transparency of bars (default \code{1})}

\item{base_size}{Numeric. Base font size for theme (default \code{12})}

\item{legend_position}{Character or numeric vector. Legend position (default \code{right})}

\item{...}{Additional ggplot2 layer arguments}
}
\value{
ggplot2 plot object
}
\description{
Creates a bar plot of relative gene expression (fold change) values
from 1-, 2-, or 3-factor experiments, including error bars and statistical
significance annotations.
}
\examples{
data <- read.csv(system.file("extdata", "data_2factorBlock.csv", package = "rtpcr"))
res <- ANOVA_DCt(data, 
    numOfFactors = 2,
    block = "block",
    numberOfrefGenes = 1)
    
df <- res$combinedResults

p1 <- plotFactor(
  data = df,
  x_col = "factor2",
  y_col = "RE",
  group_col = "factor1",
  Lower.se_col = "Lower.se.RE",
  Upper.se_col = "Upper.se.RE",
  letters_col = "sig",
  letters_d = 0.2,
  fill_colors = c("aquamarine4", "gold2"),
  alpha = 1,
  col_width = 0.7,
  dodge_width = 0.7,
  base_size = 16, 
  legend_position = c(0.2, 0.8))
  
p1



data <- read.csv(system.file("extdata", "data_3factor.csv", package = "rtpcr"))
#Perform analysis first
res <- ANOVA_DCt(
  data,
  numOfFactors = 3,
  numberOfrefGenes = 1,
  block = NULL)
  
df <- res$combinedResults
 df
 # Generate three-factor bar plot
 p <- plotFactor(
  df,
  x_col = "SA",       
  y_col = "log2FC",       
  group_col = "Type",   
  facet_col = "Conc",    
  Lower.se_col = "Lower.se.log2FC",
  Upper.se_col = "Upper.se.log2FC",
  letters_col = "sig",
  letters_d = 0.3,
  col_width = 0.7, 
  dodge_width = 0.7,
  fill_colors = c("blue", "brown"),
  base_size = 14, 
  alpha = 1,
  legend_position = c(0.1, 0.2))
p
library(ggplot2)
p + theme(
  panel.border = element_rect(color = "black", linewidth = 0.5))
  
}
\author{
Ghader Mirzaghaderi
}
