% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneFACTORfcplot.r
\name{oneFACTORfcplot}
\alias{oneFACTORfcplot}
\title{Bar plot of the average fold change for one target gene with two or more levels.}
\usage{
oneFACTORfcplot(
  x,
  numberOfrefGenes,
  levels,
  showCheckLevel = TRUE,
  level.names = "none",
  width = 0.5,
  fill = "skyblue",
  y.axis.adjust = 1,
  y.axis.by = 1,
  letter.position.adjust = 0.1,
  ylab = "Average Fold Change",
  xlab = "Pairs",
  fontsize = 12
)
}
\arguments{
\item{x}{a data frame. The data frame consists of 4 columns belonging to condition levels, E (efficiency), genes and Ct values, respectively. Each Ct in the following data frame is the mean of technical replicates. Complete amplification efficiencies of 2 is assumed here for all wells but the calculated efficienies can be used we well. We use this data set for Fold Change expression analysis of the target genes in treatment condition compared to normal condition.}

\item{numberOfrefGenes}{number of reference genes. Up to two reference genes can be handled.}

\item{levels}{a numeric vector with the length equal to the factor levels. First number indicates Control.}

\item{showCheckLevel}{a logical variable determining if the check level column be show in the plot or not.}

\item{level.names}{a vector determining level names in the x axis on the plot.}

\item{width}{a positive number determining bar width.}

\item{fill}{specify the fill color for the columns of the bar plot.}

\item{y.axis.adjust}{a negative or positive value for reducing or increasing the length of the y axis.}

\item{y.axis.by}{determines y axis step length}

\item{letter.position.adjust}{adjust the distance between the signs and the error bars.}

\item{ylab}{the title of the y axis}

\item{xlab}{the title of the x axis}

\item{fontsize}{all fonts size of the plot}
}
\value{
A list with 2 elements:
\describe{
  \item{plot}{Bar plot of the average fold change for target genes.}
  \item{Table}{Table of FC values and significance and the 95 percent CI as error bars.}
}
}
\description{
Bar plot of the relative expression of a gene along with the 95\% confidence interval and significance. There is another function, \code{qpcrTTESTplot}, that is used when the factor has two levels and represents Fold Change. \code{oneFACTORplot} is mainly useful for a one-factor experiment with more than two levels.
}
\details{
The \code{oneFACTORfcplot} function applies ANOVA based analysis where one target and one reference gene, that have been evaluated under two or more than two levels of a factor. It returns the bar plot of the average fold change for the target gene along with the 95\% CI and significance.
}
\examples{

# See sample data
data_1factor


# Producing the plot
oneFACTORfcplot(data_1factor,
                numberOfrefGenes = 1,
                levels = c(3, 2, 1),
                level.names = "none",
                showCheckLevel = TRUE,
                width = 0.5,
                fill = "skyblue",
                y.axis.adjust = 1,
                y.axis.by = 1,
                letter.position.adjust = 0.3,
                ylab = "Average Fold Change",
                xlab = "Treatment level vs Control level",
                fontsize = 12)


}
\author{
Ghader Mirzaghaderi
}
