% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timelines_statuses.R
\name{get_context}
\alias{get_context}
\title{View statuses above and below this status in the thread}
\usage{
get_context(id, instance = NULL, token = NULL, anonymous = FALSE, parse = TRUE)
}
\arguments{
\item{id}{character, local ID of a status in the database}

\item{instance}{character, the server name of the instance where the status is located. If \code{NULL}, the same instance used to obtain the token is used.}

\item{token}{user bearer token (read from file by default)}

\item{anonymous}{some API calls do not need a token. Setting anonymous to TRUE allows to make an anonymous call if possible.}

\item{parse}{logical, if \code{TRUE}, the default, returns a named list of two tibbles, representing the ancestors (statuses above the status) and descendants (statuses below the status). Use \code{FALSE}  to return the "raw" list corresponding to the JSON returned from the Mastodon API.}
}
\value{
context of a toot as tibble or list
}
\description{
Query the instance for information about the context of a specific status. A context contains statuses above and below a status in a thread.
}
\examples{
\dontrun{
get_context(id = "109294719267373593", instance = "mastodon.social")
}
}
