% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timelines_statuses.R
\name{get_timeline_hashtag}
\alias{get_timeline_hashtag}
\title{Get hashtag timeline}
\usage{
get_timeline_hashtag(
  hashtag = "rstats",
  local = FALSE,
  only_media = FALSE,
  max_id,
  since_id,
  min_id,
  limit = 20L,
  instance = NULL,
  token = NULL,
  anonymous = FALSE,
  parse = TRUE
)
}
\arguments{
\item{hashtag}{character, Content of a #hashtag. The hash is optional}

\item{local}{logical, Show only local statuses?}

\item{only_media}{logical, Show only statuses with media attached?}

\item{max_id}{character, Return results older than this id}

\item{since_id}{character, Return results newer than this id}

\item{min_id}{character, Return results immediately newer than this id}

\item{limit}{integer, Maximum number of results to return}

\item{instance}{character, the server name of the instance where the status is located. If \code{NULL}, the same instance used to obtain the token is used.}

\item{token}{user bearer token (read from file by default)}

\item{anonymous}{some API calls do not need a token. Setting anonymous to TRUE allows to make an anonymous call if possible.}

\item{parse}{logical, if \code{TRUE}, the default, returns a tibble. Use \code{FALSE}  to return the "raw" list corresponding to the JSON returned from the Mastodon API.}
}
\value{
statuses
}
\description{
Query the instance for the timeline of a specific hashtag
}
\examples{
\dontrun{
get_timeline_hashtag(hashtag = "#ichbinhanna")
## anonymously
get_timeline_hashtag(hashtag = "ichbinhanna", instance = "mastodon.social", anonymous = TRUE)
}
}
\references{
https://docs.joinmastodon.org/methods/timelines/
}
