% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_transformed_data.R
\name{to_ertmpt_data}
\alias{to_ertmpt_data}
\alias{to_rtmpt_data}
\title{Transform data to be used in RT-MPT model fitting}
\usage{
to_ertmpt_data(raw_data, model)

to_rtmpt_data(raw_data, model)
}
\arguments{
\item{raw_data}{\code{data.frame} or path to data containing columns "subj", "group", "tree", "cat", and "rt". 
If not provided in this order it will be reordered and unused variables will be moved to the end of the
new data frame.}

\item{model}{A list of the class \code{ertmpt_model}.}
}
\value{
A list of the class \code{ertmpt_data} containing transformed data and information about 
  the transformation that has been done.
}
\description{
Transform data, such that it can be used in \code{\link{fit_ertmpt}}. This implies changing each value/label in
  "subj", "group", "tree", and "cat" to numbers such that it starts from zero (e.g. data$tree = c(1,1,3,3,2,2,...)
  will be changed to data$tree = c(0,0,2,2,1,1,...)) and the columns will be ordered in the right way.
  "rt" must be provided in milliseconds. If it has decimal places it will be rounded to a whole number.
  \code{\link{fit_ertmpt}} will automatically call this function if its input is not already an \code{ertmpt_data} list, 
  but it is advised to use it anyway because it provides information about the transformations of the data.
}
\examples{
####################################################################################
# Detect-Guess variant of the Two-High Threshold model.
# The encoding and motor execution times are assumed to be equal for each response.
####################################################################################

eqn_2HTM <- "
# CORE MPT EQN
# tree ; cat  ; mpt
target ; hit  ; do
target ; hit  ; (1-do)*g
target ; miss ; (1-do)*(1-g)
       
  lure ;  f_a ; (1-dn)*g
  lure ;  c_r ; dn
  lure ;  c_r ; (1-dn)*(1-g)
"

model <- to_ertmpt_model(eqn_file = eqn_2HTM)

data_file <- system.file("extdata/labeled_data.txt", package="rtmpt")
data <- read.table(file = data_file, header = TRUE)

data_list <- to_ertmpt_data(raw_data = data, model = model)
data_list 


eqn_2HTM <- "
# CORE MPT EQN
# tree ; cat  ; mpt
target ; hit  ; do
target ; hit  ; (1-do)*g
target ; miss ; (1-do)*(1-g)
       
  lure ;  f_a ; (1-dn)*g
  lure ;  c_r ; dn
  lure ;  c_r ; (1-dn)*(1-g)
"

model <- to_rtmpt_model(eqn_file = eqn_2HTM)

data_file <- system.file("extdata/labeled_data.txt", package="rtmpt")
data <- read.table(file = data_file, header = TRUE)

data_list <- to_rtmpt_data(raw_data = data, model = model)
data_list 

}
\author{
Raphael Hartmann
}
