% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cg_memberbioroles.R
\name{cg_memberbioroles}
\alias{cg_memberbioroles}
\title{Member bio roles}
\usage{
cg_memberbioroles(memberid = NULL, key = NULL, ...)
}
\arguments{
\item{memberid}{The member's unique ID number (alphanumeric). To find a
member's ID number, get the list of members for the appropriate House
or Senate. You can also use the Biographical Directory of the United
States Congress to get a member's ID. In search results, each member's
name is linked to a record by index ID (e.g.,
http://bioguide.congress.gov/scripts/biodisplay.pl?index=C001041).
Use the index ID as member-id in your request.}

\item{key}{(character) your Propublica API key; pass in, or loads from 
.Renviron as \code{PROPUBLICA_API_KEY}. See \code{\link{rtimes-package}} 
for info on rate limits.}

\item{...}{Curl options (debugging tools mostly) passed to 
\code{\link[crul]{HttpClient}}}
}
\value{
List of members of a particular chamber in a particular Congress.
}
\description{
Get biographical and Congressional role information for a particular member of Congress.
}
\examples{
\dontrun{
cg_memberbioroles(memberid = 'S001181')
}
}
\references{
Congress API docs
\url{https://projects.propublica.org/api-docs/congress-api/}
}
\seealso{
Other congress: \code{\link{cg_billscosponsor}},
  \code{\link{cg_memberappear}},
  \code{\link{cg_memberbystatedistrict}},
  \code{\link{cg_membersleaving}},
  \code{\link{cg_memberslist}},
  \code{\link{cg_membersponsorcompare}},
  \code{\link{cg_membervotecompare}},
  \code{\link{cg_membervotepositions}},
  \code{\link{cg_newmembers}},
  \code{\link{cg_rollcallvote}}
}
