% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_compatibility.R
\name{rbindl_rtables}
\alias{rbindl_rtables}
\alias{rbind}
\alias{rbind,VTableNodeInfo-method}
\alias{rbind2,VTableNodeInfo,ANY-method}
\title{Row-bind \code{TableTree} and related objects}
\usage{
rbindl_rtables(x, gap = 0, check_headers = TRUE)

\S4method{rbind}{VTableNodeInfo}(..., deparse.level = 1)

\S4method{rbind2}{VTableNodeInfo,ANY}(x, y)
}
\arguments{
\item{x}{(\code{VTableNodeInfo})\cr \code{TableTree}, \code{ElementaryTable}, or \code{TableRow} object.}

\item{gap}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} ignored.}

\item{check_headers}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} ignored.}

\item{...}{(\code{ANY})\cr elements to be stacked.}

\item{deparse.level}{(\code{numeric(1)})\cr currently ignored.}

\item{y}{(\code{VTableNodeInfo})\cr \code{TableTree}, \code{ElementaryTable}, or \code{TableRow} object.}
}
\value{
A formal table object.
}
\description{
Row-bind \code{TableTree} and related objects
}
\note{
When objects are row-bound, titles and footer information is retained from the first object (if any exists) if all
other objects have no titles/footers or have identical titles/footers. Otherwise, all titles/footers are removed
and must be set for the bound table via the \code{\link[=main_title]{main_title()}}, \code{\link[=subtitles]{subtitles()}}, \code{\link[=main_footer]{main_footer()}}, and \code{\link[=prov_footer]{prov_footer()}}
functions.
}
\examples{
mtbl <- rtable(
  header = rheader(
    rrow(row.name = NULL, rcell("Sepal.Length", colspan = 2), rcell("Petal.Length", colspan = 2)),
    rrow(NULL, "mean", "median", "mean", "median")
  ),
  rrow(
    row.name = "All Species",
    mean(iris$Sepal.Length), median(iris$Sepal.Length),
    mean(iris$Petal.Length), median(iris$Petal.Length),
    format = "xx.xx"
  )
)

mtbl2 <- with(subset(iris, Species == "setosa"), rtable(
  header = rheader(
    rrow(row.name = NULL, rcell("Sepal.Length", colspan = 2), rcell("Petal.Length", colspan = 2)),
    rrow(NULL, "mean", "median", "mean", "median")
  ),
  rrow(
    row.name = "Setosa",
    mean(Sepal.Length), median(Sepal.Length),
    mean(Petal.Length), median(Petal.Length),
    format = "xx.xx"
  )
))

rbind(mtbl, mtbl2)
rbind(mtbl, rrow(), mtbl2)
rbind(mtbl, rrow("aaa"), indent(mtbl2))

}
