% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_funs.R
\name{remove_split_levels}
\alias{remove_split_levels}
\alias{keep_split_levels}
\alias{drop_split_levels}
\alias{drop_and_remove_levels}
\alias{reorder_split_levels}
\alias{trim_levels_in_group}
\title{Split functions}
\usage{
remove_split_levels(excl)

keep_split_levels(only, reorder = TRUE)

drop_split_levels(df, spl, vals = NULL, labels = NULL, trim = FALSE)

drop_and_remove_levels(excl)

reorder_split_levels(neworder, newlabels = neworder, drlevels = TRUE)

trim_levels_in_group(innervar)
}
\arguments{
\item{excl}{character. Levels to be excluded (they will not be reflected in the resulting table structure regardless
of presence in the data).}

\item{only}{character. Levels to retain (all others will be dropped).}

\item{reorder}{logical(1). Should the order of \code{only} be used as the order of the children of the split. defaults to \code{TRUE}}

\item{df}{dataset (data.frame or tibble)}

\item{spl}{A Split object defining a partitioning or analysis/tabulation of the data.}

\item{vals}{ANY. For internal use only.}

\item{labels}{character. Labels to use for the remaining levels instead of the existing ones.}

\item{trim}{logical(1). Should splits corresponding with 0 observations be kept when tabulating.}

\item{neworder}{character. New order or factor levels.}

\item{newlabels}{character. Labels for (new order of) factor levels}

\item{drlevels}{logical(1). Should levels in the data which do not appear in \code{neworder} be dropped. Defaults to \code{TRUE}}

\item{innervar}{character(1). Variable whose factor levels should be trimmed (ie empty levels dropped) \emph{separately within each grouping defined at this point in the structure}}
}
\value{
a closure suitable for use as a splitting function (\code{splfun}) when creating a table layout
}
\description{
Split functions
}
\examples{
l <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by("COUNTRY", split_fun = remove_split_levels(c("USA", "CAN", "CHE", "BRA"))) \%>\%
  analyze("AGE")

build_table(l, DM)

l <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by("COUNTRY", split_fun = keep_split_levels(c("USA", "CAN", "BRA"))) \%>\%
  analyze("AGE")

build_table(l, DM)
l <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by("SEX", split_fun = drop_split_levels) \%>\%
  analyze("AGE")

build_table(l, DM)
l <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by("SEX", split_fun = drop_and_remove_levels(c("M", "U"))) \%>\%
  analyze("AGE")

build_table(l, DM)
}
