% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsyslog.R
\name{open_syslog}
\alias{open_syslog}
\alias{syslog}
\alias{close_syslog}
\title{Write Messages to the System Log}
\usage{
open_syslog(identifier, open_immediately = FALSE, include_pid = FALSE,
  fallback_to_console = FALSE, echo = FALSE, facility = NULL)

syslog(message, level = "INFO", facility = NULL)

close_syslog()
}
\arguments{
\item{identifier}{A string identifying the application.}

\item{open_immediately}{When \code{TRUE}, the connection will be opened
immediately (equivalent to using \code{LOG_NDELAY}). Otherwise it will be
opened when the first message is written to the log (equivalent to using
\code{LOG_ODELAY}).}

\item{include_pid}{When \code{TRUE}, include the process ID in the log
message. Equivalent to using \code{LOG_PID}.}

\item{fallback_to_console}{Write to the system console (e.g.
\code{/dev/console}) if there is an error while sending to the system
logger. Equivalent to using \code{LOG_CONS}.}

\item{echo}{Also log the message to standard error. Equivalent to using
\code{LOG_PERROR}.}

\item{facility}{The type of program doing the logging, according to the
guidelines in \href{https://tools.ietf.org/html/rfc5424#page-10}{RFC 5424}.
Generally one of \code{"USER"} or \code{"LOCAL0"} through \code{"LOCAL7"}.
When this is \code{NULL}, fall back on the default.}

\item{message}{The message to write to the system log.}

\item{level}{The priority level of the message. One of \code{"DEBUG"},
\code{"INFO"}, \code{"NOTICE"}, \code{"WARNING"}, \code{"ERR"},
\code{"CRITICAL"}, \code{"ALERT"}, or \code{"EMERGE"} -- in that order of
priority. See \href{https://tools.ietf.org/html/rfc5424#page-11}{RFC 5424}
for the basis of this schema.}
}
\description{
Write messages to the system log via the POSIX syslog interface. Since this
is a thin wrapper around that interface, you may also want to take a look at
\href{man7.org/linux/man-pages/man3/syslog.3.html}{its documentation}. Note
that neither \code{open_syslog()} nor \code{close_syslog()} is actually
required, but using them is good practice.
}
\examples{
\dontrun{
open_syslog("my_script")
syslog("Running script.", level = "INFO")
syslog("Possible issue.", level = "WARNING")
close_syslog()

# Opening the syslog is not strictly necessary. You can
# simply write a message and it will open the log with the
# process name (likely "R") as the default.

syslog("Hello from R!", level = "WARNING")
close_syslog()
}

}
