% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applied_reshape.r
\name{split_UD_conj}
\alias{split_UD_conj}
\title{Split conjunctions for dependency trees in Universal Dependencies}
\usage{
split_UD_conj(
  tokens,
  conj_rel = "conj",
  cc_rel = c("cc", "cc:preconj"),
  unpack = T,
  no_fill = NULL,
  min_dist = 0,
  max_dist = Inf,
  right_fill_dist = T,
  compound_rel = c("compound*", "flat"),
  ...
)
}
\arguments{
\item{tokens}{a tokenIndex based on texts parsed with \code{\link[spacyr]{spacy_parse}} (with dependency=TRUE)}

\item{conj_rel}{The dependency relation for conjunctions. By default conj}

\item{cc_rel}{The dependency relation for the coordinating conjunction. By default cc. This will be removed.}

\item{unpack}{If TRUE (default), create separate branches for the parent and the node that inherits the parent position}

\item{no_fill}{Optionally, a character vector with relation types that will be excluded from fill}

\item{min_dist}{Optionally, a minimal distance between the conj node and its parent}

\item{max_dist}{Optionally, a maximum distance between the conj node and its parent}

\item{right_fill_dist}{Should fill to the right of the conjunction be used?}

\item{compound_rel}{The relation types indicating compounds}

\item{...}{specify conditions for the conjunction token. For instance, using 'pos = "VERB"' to only split VERB conjunctions.
This is especially usefull to use different no_fill conditions.}
}
\value{
A tokenindex
}
\description{
Split conjunctions for dependency trees in Universal Dependencies
}
\examples{
tokens = tokens_spacy[tokens_spacy$doc_id == 'text5',]

if (interactive()) {
tokens \%>\%
   split_UD_conj() \%>\%
   plot_tree()
}
}
