/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.xpdl;

import java.io.File;
import java.io.IOException;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.creators.DataFactory;
import org.vikamine.kernel.xpdl.DatasetProvider;

public class FileDatasetProvider
implements DatasetProvider {
    private final String fileName;
    private final String name;

    public FileDatasetProvider(String fileName) {
        this.fileName = fileName;
        this.name = new File(fileName).getName();
    }

    public FileDatasetProvider(String fileName, String alias) {
        this.fileName = fileName;
        this.name = alias;
    }

    @Override
    public Ontology getDataset(String name) {
        try {
            return DataFactory.createOntology(new File(this.fileName));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean providesDataset(String name) {
        return this.name.equals(name);
    }
}

