/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel._examples;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.creators.DataFactory;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.quality.functions.ChiSquareQF;
import org.vikamine.kernel.subgroup.search.MiningTask;
import org.vikamine.kernel.subgroup.search.SDMap;
import org.vikamine.kernel.subgroup.selectors.DefaultSGSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelectorGeneratorFactory;
import org.vikamine.kernel.subgroup.selectors.SelectorGeneratorUtils;
import org.vikamine.kernel.subgroup.target.SelectorTarget;

public class SimpleTaskRunnerExample {
    private SimpleTaskRunnerExample() {
    }

    public static void main(String[] args) throws IOException {
        Ontology onto = DataFactory.createOntology(new File("../org.vikamine.eval/resources/datasets/adults.arff"));
        System.out.println("Attributes in dataset: " + onto.getNumAttributes());
        System.out.println("Instances in dataset: " + onto.getNumInstances());
        MiningTask task = new MiningTask(onto);
        task.setTarget(new SelectorTarget(new DefaultSGSelector(onto, "class", ">50K")));
        List<SGSelector> selectors = SelectorGeneratorUtils.generateSelectors(SGSelectorGeneratorFactory.createStandardGenerator(), onto.getAttributes(), onto.getDataView());
        task.setSearchSpace(selectors);
        task.setQualityFunction(new ChiSquareQF());
        task.setMethodType(SDMap.class);
        task.setMaxSGDSize(3);
        task.setMaxSGCount(10);
        SGSet result = task.performSubgroupDiscovery();
        for (SG sg : result.toSortedList(false)) {
            System.out.println(sg.getSGDescription() + " - " + sg.getStatistics().getSubgroupSize() + "(" + sg.getStatistics().getDeviation() + ")");
        }
    }
}

