% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_value.R
\name{p_round}
\alias{p_round}
\alias{p_format}
\alias{p_mark_significant}
\alias{p_detect}
\alias{p_names}
\alias{p_adj_names}
\title{Rounding and Formatting p-values}
\usage{
p_round(x, ..., digits = 3)

p_format(x, ..., new.col = FALSE, digits = 2, accuracy = 1e-04,
  decimal.mark = ".", leading.zero = TRUE, trailing.zero = FALSE,
  add.p = FALSE, space = FALSE)

p_mark_significant(x, ..., new.col = FALSE, cutpoints = c(0, 1e-04,
  0.001, 0.01, 0.05, 1), symbols = c("****", "***", "**", "*", ""))

p_detect(data, type = c("all", "p", "p.adj"))

p_names()

p_adj_names()
}
\arguments{
\item{x}{a numeric vector of p-values or a data frame containing a p value
column. If data frame, the p-value column(s) will be automatically detected.
Known p-value column names can be obtained using the functions
\code{p_names()} and \code{p_adj_names()}}

\item{...}{column names to manipulate in the case where \code{x} is a data
frame. P value columns are automatically detected if not specified.}

\item{digits}{the number of significant digits to be used.}

\item{new.col}{logical, used only when \code{x} is a data frame. If TRUE, add
a new column to hold the results. The new column name is created by adding,
to the p column, the suffix "format" (for \code{p_format()}), "signif" (for
\code{p_mak_significant()}).}

\item{accuracy}{number to round to, that is the threshold value above wich the
function will replace the pvalue by "<0.0xxx".}

\item{decimal.mark}{the character to be used to indicate the numeric decimal
point.}

\item{leading.zero}{logical. If FALSE, remove the leading zero.}

\item{trailing.zero}{logical. If FALSE (default), remove the training extra
zero.}

\item{add.p}{logical value. If TRUE, add "p=" before the value.}

\item{space}{logical. If TRUE (default) use space as separator between
different elements and symbols.}

\item{cutpoints}{numeric vector used for intervals}

\item{symbols}{character vector, one shorter than cutpoints, used as
significance symbols.}

\item{data}{a data frame}

\item{type}{the type of p-value to detect. Can be one of \code{c("all", "p", "p.adj")}.}
}
\value{
a vector or a data frame containing the rounded/formatted p-values.
}
\description{
Round and format p-values. Can also mark significant p-values with stars.
}
\section{Functions}{
\itemize{
\item \code{p_round}: round p-values

\item \code{p_format}: format p-values. Add a symbol "<" for small p-values.

\item \code{p_mark_significant}: mark p-values with significance levels

\item \code{p_detect}: detects and returns p-value column names in a data frame.

\item \code{p_names}: returns known p-value column names

\item \code{p_adj_names}: returns known adjust p-value column names
}}

\examples{

# Round and format a vector of p-values
# ::::::::::::::::::::::::::::::::::::::::::::
# Format
p <- c(0.5678, 0.127, 0.045, 0.011, 0.009, 0.00002, NA)
p_format(p)

# Specify the accuracy
p_format(p, accuracy = 0.01)

# Add p and remove the leading zero
p_format(p, add.p = TRUE, leading.zero = FALSE)

# Remove space before and after "=" or "<".
p_format(p, add.p = TRUE, leading.zero = FALSE, space = FALSE)

# Mark significant p-values
# ::::::::::::::::::::::::::::::::::::::::::::
p_mark_significant(p)

# Round, the mark significant
p \%>\% p_round(digits = 2) \%>\% p_mark_significant()

# Format, then mark significant
p \%>\% p_format(digits = 2) \%>\% p_mark_significant()

# Perform stat test, format p and mark significant
# ::::::::::::::::::::::::::::::::::::::::::::
ToothGrowth \%>\%
  group_by(dose) \%>\%
  t_test(len ~ supp) \%>\%
  p_format(digits = 2, leading.zero = FALSE) \%>\%
  p_mark_significant()

}
