% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emmeans_test.R
\name{emmeans_test}
\alias{emmeans_test}
\alias{get_emmeans}
\title{Pairwise Comparisons of Estimated Marginal Means}
\usage{
emmeans_test(data, formula, covariate = NULL, ref.group = NULL,
  comparisons = NULL, p.adjust.method = "bonferroni",
  conf.level = 0.95, detailed = FALSE)

get_emmeans(emmeans.test)
}
\arguments{
\item{data}{a data.frame containing the variables in the formula.}

\item{formula}{a formula of the form \code{x ~ group} where \code{x} is a
numeric variable giving the data values and \code{group} is a factor with
one or multiple levels giving the corresponding groups. For example,
\code{formula = TP53 ~ cancer_group}.}

\item{covariate}{(optional) covariate names (for ANCOVA)}

\item{ref.group}{a character string specifying the reference group. If
 specified, for a given grouping variable, each of the group levels will be
 compared to the reference group (i.e. control group).

 If \code{ref.group = "all"}, pairwise two sample tests are performed for
 comparing each grouping variable levels against all (i.e. basemean).}

\item{comparisons}{A list of length-2 vectors specifying the groups of
interest to be compared. For example to compare groups "A" vs "B" and "B" vs
"C", the argument is as follow: \code{comparisons = list(c("A", "B"), c("B",
"C"))}}

\item{p.adjust.method}{method to adjust p values for multiple comparisons.
Used when pairwise comparisons are performed. Allowed values include "holm",
"hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none". If you don't
want to adjust the p value (not recommended), use p.adjust.method = "none".}

\item{conf.level}{confidence level of the interval.}

\item{detailed}{logical value. Default is FALSE. If TRUE, a detailed result is
shown.}

\item{emmeans.test}{an object of class \code{emmeans_test}.}
}
\value{
return a data frame with some the following columns: \itemize{ \item
 \code{.y.}: the y variable used in the test. \item \code{group1,group2}: the
 compared groups in the pairwise tests.
 \item \code{statistic}: Test statistic (t.ratio) used to compute the
 p-value. \item \code{df}: degrees of freedom. \item \code{p}: p-value. \item
 \code{p.adj}: the adjusted p-value. \item \code{method}: the statistical
 test used to compare groups. \item \code{p.signif, p.adj.signif}: the
 significance level of p-values and adjusted p-values, respectively. \item
 \code{estimate}: estimate of the effect size, that is the difference between
 the two emmeans (estimated marginal means). \item \code{conf.low,conf.high}:
 Lower and upper bound on a confidence interval of the estimate. }

 The \strong{returned object has an attribute called args}, which is a list
 holding the test arguments. It has also an attribute named "emmeans", a data
 frame containing the groups emmeans.
}
\description{
Performs pairwise comparisons between groups using the estimated
 marginal means. Pipe-friendly wrapper arround the functions \code{emmans() +
 contrast()} from the \code{emmeans} package, which need to be installed
 before using this function. This function is useful for performing post-hoc
 analyses following ANOVA/ANCOVA tests.
}
\section{Functions}{
\itemize{
\item \code{get_emmeans}: returns the estimated marginal means from an object of class \code{emmeans_test}
}}

\examples{
# Data preparation
df <- ToothGrowth
df$dose <- as.factor(df$dose)

# Pairwise comparisons
res <- df \%>\%
 group_by(supp) \%>\%
 emmeans_test(len ~ dose, p.adjust.method = "bonferroni")
res

# Display estimated marginal means
attr(res, "emmeans")

# Show details
df \%>\%
 group_by(supp) \%>\%
 emmeans_test(len ~ dose, p.adjust.method = "bonferroni", detailed = TRUE)
}
