% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signatures.R
\name{items_sign_bdc}
\alias{items_sign_bdc}
\alias{sign_bdc}
\title{Signature in hrefs provided by the STAC from the Brazil Data Cube
project.}
\usage{
items_sign_bdc(items, access_token = NULL, ...)

sign_bdc(access_token = NULL, ...)
}
\arguments{
\item{items}{a \code{doc_item} or \code{doc_items} object
representing the result of \verb{/stac/search},
\code{/collections/{collectionId}/items} or
\code{/collections/{collectionId}/items/{itemId}} endpoints.}

\item{access_token}{a \code{character} with the access token parameter to access
Brazil Data Cube assets.}

\item{...}{additional parameters can be supplied to the \code{GET}
function of the \code{httr} package.}
}
\value{
a \code{function} that signs each item assets.
\itemize{
\item \code{items_sign_bdc()}: items with signed assets URLs.

\item \code{sign_bdc()}: a function to to be passed to \code{items_sign()}.
}
}
\description{
These functions provide support to access assets from Brazil Data Cube.

\itemize{
\item \code{items_sign_bdc()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
A simplified function to sign assets' URL from Brazil Data Cube
to be able to access the data.

\item \code{sign_bdc()}: Creates a signing function to be
used by \code{items_sign()}. This function sign all the assets' URL.
}

To sign the hrefs with your token you need to store it in an
environment variable in \code{BDC_ACCESS_KEY}or use \code{acess_token} parameter.
}
\examples{
\dontrun{
 # doc_items object
 stac_obj <- stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
   stac_search(collections = "CB4-16D-2",
               datetime = "2019-06-01/2019-08-01") \%>\%
   stac_search() \%>\%
   get_request()

 # the new way to authenticate:
 stac_obj <- stac_obj \%>\%
   items_sign_bdc("<your-access-token>")

 # this is the old way of authentication (still works):
 # stac_obj \%>\%
 #   items_sign(sign_fn = sign_bdc(access_token = "<your-access-token>"))
}

}
