\name{simldata}
\alias{simldata}
\title{Simulate Longitudinal Data}
\description{Simulate longitudinal data from linear and generalized linear mixed models. The coefficients of the two covariate are specified by \code{beta}.}
\usage{simldata(family=c("binomial","gaussian"),beta=c(2,0),tau=1,n=200,m=10,
         balance=TRUE,rho=0.5)}
\arguments{
    \item{family}{ the family of the distribution.}
    \item{beta}{ regression coefficients (excluding the intercept which is set as zero).}
    \item{tau}{ the variance of the random intercept.}
    \item{n}{ the sample size.}
    \item{m}{ the number of groups.}
    \item{balance}{ simulate balanced data if TRUE, unbalanced data otherwise.}
    \item{rho}{ the parameter for AR(1) errors.}
}
\details{
The first covariate takes 1 in half of the observations, and 0 or -1 in the other half. When \code{beta} gets larger, it is supposed to easier to predict the response variable. The binomial data is generated by thresholding Gaussian responses at zero, so the link function of the binomial model is probit.
}
\value{
Returned values include \code{yx}, \code{beta}, and \code{u}.
\item{yx}{ a data frame including the response \code{y} and covariates \code{x1}, \code{x2}, and so on.}
\item{beta}{ true values of the regression coefficients.}
\item{u}{ the random intercepts.}
}
\references{
Zhang, D. (2020). Coefficients of determination for generalized linear mixed models. \emph{Technical Report}, 20-01, Department of Statistics, Purdue University.
}
\author{Dabao Zhang, Department of Statistics, Purdue University}
\seealso{
\code{\link{rsq}, \link{rsq.lmm}, \link{rsq.glmm}, \link{simglmm}, \link{simglm}},
}
\examples{
require(lme4)

# Generalized linear mixed models
pdata <- simldata(family="binomial",n=400,m=20,balance=FALSE)
plmm <- glmer(y~x1+x2+(1|subject),family=binomial(link="probit"),data=pdata$yx)
rsq(plmm)
}
