% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_NHANES3.R
\name{pred_NHANES3}
\alias{pred_NHANES3}
\title{Calculate predicted values of spirometry parameters using NHANES III equations}
\usage{
pred_NHANES3(age, height, gender = 1, ethnicity = 1, param = "FEV1")
}
\arguments{
\item{age}{Age in years}

\item{height}{Height in meters}

\item{gender}{Gender (1 = male, 2 = female) or a factor with two levels (first = male). Default is 1.}

\item{ethnicity}{Ethnicity (1 = Caucasian, 2 = African-American,
3 = Mexican-American). Default is 1.}

\item{param}{A character vector, containing one of more of the following parameters (case insensitive):
"FEV1", "FVC", "FEV1FVC", "PEF", "FEF2575", "FEV6", "FEV1FEV6"}
}
\value{
If \code{param} has length one, the function returns a numeric vector. If \code{param}
has length >1, it returns a data.frame with \code{length(param)} columns.
}
\description{
This function calculates the mean normal (predicted) values for the various spirometry
parameters, using the NHANES III equations. It accepts as input age, height, gender and ethnicity.
}
\details{
Arguments \code{age}, \code{height}, \code{gender} and \code{ethnicity} are vectors
of equal length, or of length one, in which case the value is recycled; if the four vectors are
not of equal length, the function stops with an error.
}
\examples{
# Find predicted FEV1 and FVC for Caucasian women aged 20 to 70 and with a height of 1.70 meters.
pred_NHANES3(20:70, 1.7, 2, param=c("FEV1","FVC"))

}
