## ----setup, include = FALSE-------------------------------------------------------------------------------------------------------------------------
options(width = 150)
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.align = "center", fig.height = 6, fig.width = 6,
  out.width = "75%"
)

## ----packages---------------------------------------------------------------------------------------------------------------------------------------
library(rsimsum)
data("tt", package = "rsimsum")
head(tt)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
t.test(extra ~ group, data = sleep)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
s1 <- simsum(data = tt, estvarname = "diff", true = -1, se = "se", ci.limits = c("lower", "upper"), methodvar = "method", by = "dgm")
summary(s1, stats = "cover")

## ---------------------------------------------------------------------------------------------------------------------------------------------------
s2 <- simsum(data = tt, estvarname = "diff", true = -1, se = "se", methodvar = "method", by = "dgm")
summary(s2, stats = "cover")

## ---------------------------------------------------------------------------------------------------------------------------------------------------
s3 <- simsum(data = tt, estvarname = "diff", true = -1, se = "se", ci.limits = c(-1.5, -0.5), methodvar = "method", by = "dgm")
summary(s3, stats = "cover")

## ---------------------------------------------------------------------------------------------------------------------------------------------------
tt$true <- -1
s4 <- simsum(data = tt, estvarname = "diff", true = "true", se = "se", ci.limits = c("lower", "upper"), methodvar = "method", by = "dgm")
summary(s4, stats = "cover")

## ---------------------------------------------------------------------------------------------------------------------------------------------------
summary(s2, stats = "cover")

## ---------------------------------------------------------------------------------------------------------------------------------------------------
data("frailty", package = "rsimsum")
ms1 <- multisimsum(
  data = frailty,
  par = "par", true = c(trt = -0.50, fv = 0.75),
  estvarname = "b", se = "se", methodvar = "model",
  by = "fv_dist"
)
summary(ms1, stats = "bias")

## ---------------------------------------------------------------------------------------------------------------------------------------------------
frailty$true <- ifelse(frailty$par == "trt", -0.50, 0.75)
head(frailty)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
ms2 <- multisimsum(
  data = frailty,
  par = "par", true = "true",
  estvarname = "b", se = "se", methodvar = "model",
  by = "fv_dist"
)
summary(ms2, stats = "bias")

## ---------------------------------------------------------------------------------------------------------------------------------------------------
identical(get_data(ms1), get_data(ms2))

## ---------------------------------------------------------------------------------------------------------------------------------------------------
ms3 <- multisimsum(
  data = frailty,
  par = "par", true = "true",
  estvarname = "b", se = "se", methodvar = "model",
  by = "fv_dist",
  ci.limits = c(-1, 1)
)
summary(ms3, stats = "cover")

## ---------------------------------------------------------------------------------------------------------------------------------------------------
summary(ms2, stats = "cover")

