% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extendr-wrappers.R
\name{intersects_sparse}
\alias{intersects_sparse}
\alias{intersects_pairwise}
\alias{contains_sparse}
\alias{contains_pairwise}
\alias{within_sparse}
\alias{within_pairwise}
\title{Binary Predicates}
\usage{
intersects_sparse(x, y)

intersects_pairwise(x, y)

contains_sparse(x, y)

contains_pairwise(x, y)

within_sparse(x, y)

within_pairwise(x, y)
}
\arguments{
\item{x}{an object of class \code{rsgeo}}

\item{y}{an object of class \code{rsgeo}}
}
\value{
\itemize{
\item For \verb{_sparse} a list of integer vectors containing the position
of the geometry in \code{y}
\item For \verb{_pairwise} a logical vector
}
}
\description{
Functions to ascertain the binary relationship between
two geometry vectors. Binary predicates are provided both pairwise
as a sparse matrix.
}
\examples{
if (rlang::is_installed("sf")) {
    nc <- sf::st_read(
      system.file("shape/nc.shp", package = "sf"),
      quiet = TRUE
    )
    
    x <- as_rsgeo(nc$geometry[1:5])
    y <- rev(x)
    
    # intersects
    intersects_sparse(x, y)
    intersects_pairwise(x, y)
    # contains 
    contains_sparse(x, y)
    contains_pairwise(x, y)
    # within
    within_sparse(x, y)
    within_pairwise(x, y)
}
}
