% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configureApp.R
\name{unsetProperty}
\alias{unsetProperty}
\title{Unset Application property}
\usage{
unsetProperty(
  propertyName,
  appPath = getwd(),
  appName = NULL,
  account = NULL,
  server = NULL,
  force = FALSE
)
}
\arguments{
\item{propertyName}{Name of property}

\item{appPath}{Directory or file that was deployed. Defaults to current
working directory.}

\item{appName}{Name of application}

\item{account, server}{Uniquely identify a remote server with either your
user \code{account}, the \code{server} name, or both. If neither are supplied, and
there are multiple options, you'll be prompted to pick one.

Use \code{\link[=accounts]{accounts()}} to see the full list of available options.}

\item{force}{Forcibly unset the property}
}
\description{
Unset a property on currently deployed ShinyApps application (restoring to
its default value)

Supported servers: ShinyApps servers
}
\note{
This function only works for ShinyApps servers.
}
\examples{
\dontrun{

# unset application package cache property to revert to default
unsetProperty("application.package.cache")

}
}
