% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/params.R
\name{ss.options}
\alias{ss.options}
\title{Set or reset parameters to be used by SaTScan}
\usage{
ss.options(invals = NULL, reset = FALSE)
}
\arguments{
\item{invals}{A list with entries of the form name=value, where value should be
in quotes unless it is a number. Alternatively, may be a character vector whose
entries are of the form "name=value".  The "name" in either case should be a
valid SaTScan parameter name; unrecognized names will generate a warning and will
do nothing.}

\item{reset}{If TRUE, will restore the default parameter values described in
the "Details" section.}
}
\value{
If \code{invals == NULL}, returns the current parameter set,
as altered by previous
calls to \code{ss.options()} since the last call with \code{reset=TRUE}.  Otherwise
returns modified parameter set invisibly.  The side effect, if \code{invals != NULL}, is to
set the current values of the parameters per the value of \code{invals}
and \code{reset}.
}
\description{
Set or reset parameters to be used by SaTScan
}
\details{
\code{ss.options()} is intended to function like \code{par()} or
\code{options()}.  There is a default set of parameter settings that resembles
the one used by SaTScan, except that it produces all possible output files and
makes them as .dbf files instead of text.
}
\examples{
\dontrun{
head(ss.options(),3)
ss.options(list(CaseFile="NYCfever.cas"))
head(ss.options(),3)

# reset; shows whole parameter file without invisible()
invisible(ss.options(reset=TRUE))
head(ss.options(),3)
}
}

