% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtoi.R
\name{get_database}
\alias{get_database}
\alias{get_database,rtoi-method}
\alias{get_database,rtoi}
\alias{get_database,missing-method}
\alias{set_database}
\alias{set_database,rtoi-method}
\alias{set_database,character-method}
\title{Extracts or assign the path of the database}
\usage{
get_database(x)

\S4method{get_database}{rtoi}(x)

\S4method{get_database}{missing}()

set_database(x, ...)

\S4method{set_database}{rtoi}(x, value)

\S4method{set_database}{character}(x)
}
\arguments{
\item{x}{an rtoi object.}

\item{...}{additional arguments.}

\item{value}{character argument. The value for
change the database directory of x.}
}
\value{
the database path of an rtoi
}
\description{
Extracts the path to the database from an rtoi/package environment.
If both, environment and rtoi database are defined the rtoi
database is used.
}
\examples{
\dontrun{
# load example rtoi
file.copy(from=system.file("ex/Navarre",package="rsat"),
         to=tempdir(),
         recursive = TRUE)

navarre <- read_rtoi(file.path(tempdir(),"Navarre"))

# get the databse used by navarre
get_database(navarre)

# set the a new database path
set_database(navarre,"new_path")

# get the database used by rsat by default
get_database()

# set the a new database path for the entire environment
set_database("new_path")
}
}
