% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hotMoveStats.R
\name{hotMoveStats}
\alias{hotMoveStats}
\title{hotMoveStats}
\usage{
hotMoveStats(region.id = region.id, obs.time = obs.time,
  individual.id = NULL)
}
\arguments{
\item{region.id}{Region unique identifiers. Vector of class \emph{numeric}.}

\item{obs.time}{Observation time. Object of class \emph{Date}.}

\item{individual.id}{Individual identifier. Vector of class \emph{character}.}
}
\value{
A list containing statistical information for each region (\emph{region.stats}) and for each temporal segment (\emph{temporal.segment.stats}) and sample indices for each segment (temporal.segment.indices)
}
\description{
{Segmentation and statistical analysis of the time spent by an animal within a geographical region.}
}
\details{
{For each unique region defined by \emph{region.id}, the function identifies unique temporal segments
defined as periods of consecutive days with observations. Then, for each region, the function uses the identified segments
to report on the minimum, maximum and mean time spent as well as the total amount of time spent within the region.
Moreover, the function provides a detailed report of each segment and informs on the corresponding sample indices. If
\emph{individual.id} is specified, the function will in addition count the number of individuals found within each region
and within each temporal segment.}
}
\examples{
{

require(raster)

# reference data
data(longMove)

# extract regions
hm <- hotMove(xy=longMove, pixel.res=0.1, return.shp=TRUE)

# plot shapefile (color by region)
plot(hm$polygons)

# add new information to original shapefile
longMove@data <- cbind(longMove@data, hm$indices)

# derive statistics
hm.region.stats <- hotMoveStats(region.id=hm$indices,
obs.time=as.Date(longMove@data$timestamp))

}
}
\seealso{
\code{\link{hotMove}}
}
