/*
 * Decompiled with CFR 0.152.
 */
package nbl.utilj;

import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import nbl.utilj.GuiMetrics;

public class GuiUtil {
    public static void exceptionMessage(Throwable x) {
        JOptionPane.showMessageDialog(null, "<html>" + x.toString() + "<br><br>" + GuiUtil.stackTraceToString(x.getStackTrace()) + "</html>", "Exception", 0);
    }

    public static String stackTraceToString(StackTraceElement[] trace) {
        if (trace == null) {
            return "NULL stack trace.";
        }
        String s = "";
        for (int i = 0; i < trace.length; ++i) {
            s = trace[i] != null ? s + trace[i].toString() + "<br>" : s + "null trace element at [" + i + "]";
        }
        return s;
    }

    public static void centerOnScreen(Container c) {
        Dimension d = c.getPreferredSize();
        int center_x = GuiMetrics.roundMult(GuiMetrics.getScreenWidth(), 0.5f);
        int center_y = GuiMetrics.roundMult(GuiMetrics.getScreenHeight(), 0.5f);
        int dx = GuiMetrics.roundMult(d.width, 0.5f);
        int dy = GuiMetrics.roundMult(d.height, 0.5f);
        c.setLocation(center_x - dx, center_y - dy);
    }

    public static void locateAtUpperRight(Container c) {
        Dimension d = c.getPreferredSize();
        c.setLocation(GuiMetrics.getScreenWidth() - d.width, 0);
    }

    public static void locateAtCenterRight(Container c) {
        Dimension d = c.getPreferredSize();
        int dy = GuiMetrics.roundMult(d.height, 0.5f);
        int center_y = GuiMetrics.roundMult(GuiMetrics.getScreenHeight(), 0.5f);
        c.setLocation(GuiMetrics.getScreenWidth() - 2 * d.width, center_y - dy);
    }

    public static boolean answerIsYes(String[] mess, String title) {
        int r = JOptionPane.showConfirmDialog(null, mess, title, 0);
        return r == 0;
    }

    public static int answerIsYesNoCancel(String[] mess, String title) {
        return JOptionPane.showConfirmDialog(null, mess, title, 1);
    }

    public static void warning(String[] mess, String title) {
        JOptionPane.showMessageDialog(null, mess, title, 2);
    }

    public static void info(String[] mess, String title) {
        JOptionPane.showMessageDialog(null, mess, title, 1);
    }

    public static File getFile(String title, File initialDir) {
        JFileChooser fChooser = new JFileChooser(initialDir);
        fChooser.setFileSelectionMode(0);
        fChooser.setDialogTitle(title);
        if (fChooser.showOpenDialog(null) != 0) {
            return null;
        }
        File c = fChooser.getSelectedFile();
        return c;
    }
}

