% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RRepast.R
\name{Easy.Calibration}
\alias{Easy.Calibration}
\title{Easy.Calibration}
\usage{
Easy.Calibration(m.dir, m.ds, m.time = 300, parameters, exp.n = 100,
  exp.r = 1, smax = 4, design = "lhs", FUN)
}
\arguments{
\item{m.dir}{The installation directory of some repast model}

\item{m.ds}{The name of any model aggregate dataset}

\item{m.time}{The total simulated time}

\item{parameters}{The input factors}

\item{exp.n}{The experiment sample size}

\item{exp.r}{The number of experiment replications}

\item{smax}{The number of solutions to be generated}

\item{design}{The sampling scheme ["lhs"|"mcs"|"ffs"]}

\item{FUN}{The calibration function.}
}
\value{
A list with holding experiment, object and charts
}
\description{
Search for the best set of parameters trying to 
minimize the calibration function provided by the user. The function 
has to operational models, the first based on the experimental setup 
where all parameters are defined a priori and the second using 
optimization techniques. Currently the only supported optimization 
technique is the particle swarm optimization.
}
\examples{
\dontrun{
 my.cost<- function(params, results) {
   criteria<- c()
   Rate<- AoE.RMSD(results$X.Simulated,results$X.Experimental)
   G<- AoE.RMSD(results$G.T.,52)
   total<- Rate + G
   criteria<- cbind(total,Rate,G)
   return(criteria)
 }
 
 Easy.Setup("/models/BactoSim")
 v<- Easy.Calibration("/models/BactoSim","ds::Output",360,
                       f,exp.n = 1000, exp.r=1, smax=4, 
                       design="mcs", my.cost)
 
}

}

