% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rrd-package.R
\docType{package}
\name{rrd-package}
\alias{rrd-package}
\alias{_PACKAGE}
\alias{rrd}
\title{rrd: Import Data from a RRD (Round Robin Database) File}
\description{
\if{html}{\figure{logo.png}{options: align='right' alt='logo' width='120'}}

Makes it easy to import the data from a 'RRD' database (<https://oss.oetiker.ch/rrdtool/>) directly into R data structures. The resulting objects are 'tibble' objects or a list of 'tibble' objects, making it easy to manipulate the data. The package uses 'librrd' to import the numerical data in a 'RRD' database directly into R data structures without using intermediate formats.
}
\section{Details}{


Exposes the following functions:
\itemize{
\item \code{\link[=describe_rrd]{describe_rrd()}} to enumerate the archives included in a RRD file.
\item \code{\link[=read_rrd]{read_rrd()}} to read an entire RRD file, including all the archives
\item \code{\link[=read_rra]{read_rra()}} to extract a single RRA (round robin archive) from an RRD file
}

For more information on \code{RRdtool} and the \code{RRD} format please refer to the official RRDtool \href{https://oss.oetiker.ch/rrdtool/doc/index.en.html}{documentation} and \href{https://oss.oetiker.ch/rrdtool/tut/index.en.html}{tutorials}.

You can also read a more in-depth description of the package in an \href{https://rviews.rstudio.com/}{R Views} blog post \href{https://rviews.rstudio.com/2018/06/20/reading-rrd-files/}{Reading and analysing log files in the RRD database format}.
}

\section{Package history}{


Plamen Dimitrov wrote the original proof of concept of the package during a Google \href{https://www.google-melange.com/archive/gsoc/2014}{Summer of Code 2014} project and wrote an accompanying blog post "\href{http://plamendimitrov.net/blog/2014/08/09/r-package-for-working-with-rrd-files/}{R Package for Working With RRD Files}".

Andrie de Vries became maintainer of the package early in 2018, and prepared the package for release to CRAN by adding documentation, examples and unit tests. At this time the API changed so resulting objects are \code{tibble} objects, making it easier to analyse data using \code{tidyverse} concepts.  At this time he also published the "R Views" \href{https://rviews.rstudio.com/2018/06/20/reading-rrd-files/}{blog post}.
}

\references{
\url{https://oss.oetiker.ch/rrdtool/doc/index.en.html}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/andrie/rrd/}
  \item \url{https://andrie.github.io/rrd/}
  \item Report bugs at \url{https://github.com/andrie/rrd/issues}
}

}
\author{
\strong{Maintainer}: Andrie de Vries \email{apdevries@gmail.com} [copyright holder]

Authors:
\itemize{
  \item Plamen Dimitrov \email{dim.plamen@gmail.com} [copyright holder]
}

Other contributors:
\itemize{
  \item Tobias Oettiker (rrdtool and rrd library, https://oss.oetiker.ch/rrdtool/) [copyright holder]
}

}
\keyword{librrd}
\keyword{package}
\keyword{rrd}
\keyword{rrdtool}
