% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rr.R
\name{predict.rrreg}
\alias{predict.rrreg}
\title{Predicted Probabilities for Randomized Response Regression}
\usage{
predict.rrreg(object, given.y = FALSE, alpha = .05, n.sims =
1000, avg = FALSE, newdata = NULL, quasi.bayes = FALSE, keep.draws = FALSE,
...)
}
\arguments{
\item{object}{An object of class "rrreg" generated by the \code{rrreg()}
function.}

\item{given.y}{Indicator of whether to use "y" the response vector to
calculate the posterior prediction of latent responses. Default is
\code{FALSE}, which simply generates fitted values using the logistic
regression.}

\item{alpha}{Confidence level for the hypothesis test to generate upper and
lower confidence intervals. Default is \code{ .05}.}

\item{n.sims}{Number of sampled draws for quasi-bayesian predicted
probability estimation. Default is \code{1000}.}

\item{avg}{Whether to output the mean of the predicted probabilities and
uncertainty estimates. Default is \code{FALSE}.}

\item{newdata}{Optional new data frame of covariates provided by the user.
Otherwise, the original data frame from the "rreg" object is used.}

\item{quasi.bayes}{Option to use Monte Carlo simulations to generate
uncertainty estimates for predicted probabilities. Default is \code{FALSE}.}

\item{keep.draws}{Option to return the Monte Carlos draws of the quantity of
interest, for use in calculating differences for example.}

\item{...}{Further arguments to be passed to \code{predict.rrreg()} command.}
}
\value{
\code{predict.rrreg} returns predicted probabilities either for each
observation in the data frame or the average over all observations. The
output is a list that contains the following components:

\item{est}{Predicted probabilities for the randomized response item
generated either using fitted values, posterior predictions, or
quasi-Bayesian simulations. If \code{avg} is set to \code{TRUE}, the output
will only include the mean estimate.} \item{se}{Standard errors for the
predicted probabilities of the randomized response item generated using
Monte Carlo simulations. If \code{quasi.bayes} is set to \code{FALSE}, no
standard errors will be outputted.} \item{ci.lower}{Estimates for the lower
confidence interval. If \code{quasi.bayes} is set to \code{FALSE}, no
confidence interval estimate will be outputted.} \item{ci.upper}{Estimates
for the upper confidence interval. If \code{quasi.bayes} is set to
\code{FALSE}, no confidence interval estimate will be outputted.}
\item{qoi.draws}{Monte Carlos draws of the quantity of interest, returned
only if \code{keep.draws} is set to \code{TRUE}.}
}
\description{
\code{predict.rrreg} is used to generate predicted probabilities from a
multivariate regression object of survey data using randomized response
methods.
}
\details{
This function allows users to generate predicted probabilities for the
randomized response item given an object of class "rrreg" from the
\code{rrreg()} function. Four standard designs are accepted by this
function: mirrored question, forced response, disguised response, and
unrelated question. The design, already specified in the "rrreg" object, is
then directly inputted into this function.
}
\examples{

\dontrun{
data(nigeria)

set.seed(1)

## Define design parameters
p <- 2/3  # probability of answering honestly in Forced Response Design
p1 <- 1/6 # probability of forced 'yes'
p0 <- 1/6 # probability of forced 'no'

## Fit linear regression on the randomized response item of 
## whether citizen respondents had direct social contacts to armed groups

rr.q1.reg.obj <- rrreg(rr.q1 ~ cov.asset.index + cov.married + I(cov.age/10) + 
                      I((cov.age/10)^2) + cov.education + cov.female,   
                      data = nigeria, p = p, p1 = p1, p0 = p0, 
                      design = "forced-known")

## Generate the mean predicted probability of having social contacts to 
## armed groups across respondents using quasi-Bayesian simulations. 

rr.q1.reg.pred <- predict(rr.q1.reg.obj, given.y = FALSE, 
                                avg = TRUE, quasi.bayes = TRUE, 
                                n.sims = 10000)

## Replicates Table 3 in Blair, Imai, and Zhou (2014)
}

}
\references{
Blair, Graeme, Kosuke Imai and Yang-Yang Zhou. (2014) "Design
and Analysis of the Randomized Response Technique."  \emph{Working Paper.}
Available at \url{http://imai.princeton.edu/research/randresp.html}.
}
\seealso{
\code{\link{rrreg}} to conduct multivariate regression analyses in
order to generate predicted probabilities for the randomized response item.
}
\keyword{fitted}
\keyword{predicted}
\keyword{probabilities}
\keyword{values}

