% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_ops.R
\name{rq_connection_name}
\alias{rq_connection_name}
\title{Build a canonical name for a db connection class.}
\usage{
rq_connection_name(db)
}
\arguments{
\item{db}{Database connection handle.}
}
\value{
character, key version of handle for option lookups.
}
\description{
Build a canonical name for a db connection class.
}
\examples{

if(requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  print(rq_connection_name(my_db))
  DBI::dbDisconnect(my_db)
}

}
