% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_z.R
\name{extract_z}
\alias{extract_z}
\alias{extract_z.coxph}
\alias{extract_z.survdiff}
\alias{extract_z.survreg}
\title{Extracting the z-statistic from a survival object}
\usage{
extract_z(x, ...)

\method{extract_z}{survdiff}(fit, ...)

\method{extract_z}{coxph}(fit, arm, ...)

\method{extract_z}{survreg}(fit, arm, ...)
}
\arguments{
\item{x}{an R object}

\item{...}{extendible arguments to the S3 method}

\item{fit}{a fitted survival object : survdiff, coxph, survreg}

\item{arm}{a character vector giving the name of the covariate representing the treatment arm.}
}
\value{
a numeric value, the z statistic for the independence test of the treatment arm
}
\description{
Generic S3 methods to extract the z-statistic from a set of survival fit objects
}
\section{Methods (by class)}{
\itemize{
\item \code{survdiff}: Method for survdiff

\item \code{coxph}: Method for coxph objects

\item \code{survreg}: Method for survreg objects
}}
\author{
Simon Bond
}
\keyword{internal}

