% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/extract.R
\name{extract_chunks}
\alias{extract_chunks}
\title{Extract log-frames from an Eprime log file}
\usage{
extract_chunks(eprime_log)
}
\arguments{
\item{eprime_log}{a character vector containing the lines of text from Eprime
txt file}
}
\value{
a list of character vectors, where each vector contains the lines of
  a log-frame
}
\description{
Almost all of the information in an Eprime file comes in chunks of text
bracketed by the lines \code{*** LogFrame Start ***} and \code{*** LogFrame
End ***}. The exception is the header information which is bracketed by
\code{*** Header Start ***} and \code{*** Header End ***}.
}
\details{
\code{extract_chunks} extracts the bracketed text, storing each log-frame of
text in a list. The lists also include some additional lines of text as
metadata: \code{Eprime.FrameNumber} and \code{Eprime.Basename} (the name of
the source file). The header log-frame also gets dummy lines:
\code{Procedure: Header} and \code{Running: Header}.

These chunks of colon-separated lines are converted into lists by
\code{FrameList(...)}.
}

