% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/msa.R
\name{ncol.msa}
\alias{ncol.msa}
\title{MSA Sequence Length.}
\usage{
\method{ncol}{msa}(x, refseq = NULL)
}
\arguments{
\item{x}{an MSA object}

\item{refseq}{character vector giving name(s) of sequence whose
length to return.  The default \code{NULL} implies the frame of
reference of the entire alignment.}
}
\value{
an integer vector containing the length of the named sequences.
If refseq is NULL, returns the number of columns in the alignment.
}
\description{
Returns the length of sequence in an MSA alignment.
}
\examples{
m <- msa(seqs=c("A--ACGTAT", "AG-AGGTAA", "AGGAGGTAG"),
         names=c("human", "mouse", "rat"))
ncol.msa(m)
ncol.msa(m, names.msa(m))
}
\author{
Melissa J. Hubisz and Adam Siepel
}
\seealso{
\code{\link{msa}}
}
\keyword{msa}

